import 'package:flutter/foundation.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mypoint_flutter_app/base/app_loading.dart';
import '../networking/dio_http_service.dart';
import '../resources/base_color.dart';
import '../widgets/alert/custom_alert_dialog.dart';
import '../widgets/alert/data_alert_model.dart';
import '../widgets/alert/popup_data_model.dart';

abstract class BaseScreen extends StatefulWidget {
  const BaseScreen({super.key});
}

abstract class BaseState<Screen extends BaseScreen> extends State<Screen> {
  @override
  void initState() {
    super.initState();
    if (kDebugMode) {
      print("_show: $runtimeType");
    }
  }

  showPopup({
    required PopupDataModel data,
    bool? barrierDismissibl,
    bool showCloseButton = false,
    ButtonsDirection direction = ButtonsDirection.column,
  }) {
    Get.dialog(
      CustomAlertDialog(alertData: data.dataAlertModel, showCloseButton: showCloseButton, direction: direction),
      barrierDismissible: barrierDismissibl ?? true,
    );
  }

  showAlert({
    required DataAlertModel data,
    bool? barrierDismissibl,
    bool showCloseButton = true,
    ButtonsDirection direction = ButtonsDirection.column,
  }) {
    Get.dialog(
      CustomAlertDialog(alertData: data, showCloseButton: showCloseButton, direction: direction),
      barrierDismissible: barrierDismissibl ?? false,
    );
  }

  showAlertError({
    required String content,
    bool? barrierDismissible,
    String headerImage = "assets/images/ic_pipi_03.png",
    bool showCloseButton = true,
    VoidCallback? onConfirmed,
  }) {
    Get.dialog(
      CustomAlertDialog(
        showCloseButton: showCloseButton,
        alertData: DataAlertModel(
          localHeaderImage: headerImage,
          title: "",
          description: content,
          buttons: [
            AlertButton(
              text: "Đã Hiểu",
              onPressed: () {
                Get.back();
                if (onConfirmed != null) {
                  onConfirmed();
                }
              },
              bgColor: BaseColor.primary500,
              textColor: Colors.white,
            ),
          ],
        ),
      ),
      barrierDismissible: barrierDismissible ?? false,
    );
  }

  hideKeyboard() {
    FocusScope.of(context).unfocus();
  }

  void printDebug(dynamic data) {
    if (kDebugMode) {
      print(data);
    }
  }

  Widget? createBottomBar() {
    return null;
  }
}
