import 'package:flutter/material.dart';
import 'package:flutter_localizations/flutter_localizations.dart';
import 'package:get/get.dart';
import 'package:mypoint_flutter_app/networking/app_navigator.dart';
import 'package:mypoint_flutter_app/configs/api_paths.dart';
import 'package:mypoint_flutter_app/preference/data_preference.dart';
import 'package:mypoint_flutter_app/preference/point/point_manager.dart';
import 'package:mypoint_flutter_app/resources/base_color.dart';
import 'package:mypoint_flutter_app/screen/home/header_home_viewmodel.dart';
import 'package:mypoint_flutter_app/shared/router_gage.dart';
import 'base/app_loading.dart';
import 'networking/dio_http_service.dart';

void main() async {
  WidgetsFlutterBinding.ensureInitialized();
  Get.put(HeaderThemeController(), permanent: true);
  await DataPreference.instance.init();
  DioHttpService().setBaseUrl(APIPaths.baseUrl);
  await UserPointManager().fetchUserPoint();
  runApp(const MyApp());
  AppLoading().attach();
}

class MyApp extends StatelessWidget {
  const MyApp({super.key});

  @override
  Widget build(BuildContext context) {
    return GetMaterialApp(
      navigatorKey: AppNavigator.key,
      debugShowCheckedModeBanner: false,
      initialRoute: '/splash',
      theme: ThemeData(
        colorScheme: ColorScheme.fromSwatch(primarySwatch: Colors.brown),
        primaryColor: BaseColor.primary500,
      ),
      locale: const Locale('vi'),
      supportedLocales: const [
        Locale('vi', 'VN'), // Vietnamese
      ],
      localizationsDelegates: const [
        GlobalMaterialLocalizations.delegate,
        GlobalWidgetsLocalizations.delegate,
        GlobalCupertinoLocalizations.delegate,
      ],
      // home: SplashScreen(),
      getPages: RouterPage.pages(),
    );
  }
}