import 'package:get/get.dart';
import 'package:mypoint_flutter_app/networking/restful_api_client_all_request.dart';
import '../../networking/restful_api_viewmodel.dart';
import '../data_preference.dart';
import 'header_home_model.dart';

class UserPointManager extends RestfulApiViewModel {
  static final UserPointManager _instance = UserPointManager._internal();
  factory UserPointManager() => _instance;
  UserPointManager._internal();

  final RxInt _userPoint = 0.obs;
  HeaderHomeModel? _headerInfo;

  get point => _userPoint.value;

  Future<int?> fetchUserPoint() async {
    if (!DataPreference.instance.logged) return null;
    try {
      final response = await client.getHomeHeaderData();
      if (response.isSuccess && response.data != null) {
        _headerInfo = response.data;
        _userPoint.value = _headerInfo?.totalPointActive ?? 0;
        return _userPoint.value;
      } else {
        _userPoint.value = 0;
        return null;
      }
    } catch (e) {
      _userPoint.value = 0;
      return null;
    }
  }
}
