import 'package:get/get.dart';
import 'package:mypoint_flutter_app/configs/constants.dart';
import 'package:mypoint_flutter_app/networking/restful_api_client_all_request.dart';
import '../../networking/restful_api_viewmodel.dart';
import 'models/affiliate_brand_detail_model.dart';

class AffiliateBrandDetailViewModel extends RestfulApiViewModel {
  String brandId;
  AffiliateBrandDetailViewModel(this.brandId);

  void Function(String message)? onShowAlertError;
  var isLoading = false.obs;
  var brandDetailData = Rxn<AffiliateBrandDetailModel>();

  @override
  void onInit() {
    super.onInit();
    _getAffiliateBrandDetail();
  }

  Future<void> _getAffiliateBrandDetail() async {
    showLoading();
    if (isLoading.value) return;
    try {
      isLoading.value = true;
      final response = await client.getAffiliateBrandDetail(brandId);
      hideLoading();
      if (response.isSuccess) {
        brandDetailData.value = response.data;
      } else {
        onShowAlertError?.call(response.errorMessage ?? Constants.commonError);
      }
    } catch (error) {
      showLoading();
      onShowAlertError?.call("Error fetching product detail: $error");
    } finally {
      isLoading.value = false;
    }
  }
}
