import 'package:flutter/foundation.dart';
import 'package:get/get.dart';
import 'package:mypoint_flutter_app/networking/restful_api_client_all_request.dart';
import '../../networking/restful_api_viewmodel.dart';
import 'bank_account_info_model.dart';

class BankAccountManagerViewModel extends RestfulApiViewModel {
  final RxList<BankAccountInfoModel> bankAccounts = <BankAccountInfoModel>[].obs;

  @override
  onInit() {
    super.onInit();
    getBankAccountList();
  }

  getBankAccountList() async {
    showLoading();
    try {
      final result = await client.getOrderPaymentMyAccounts();
      hideLoading();
      bankAccounts.value = result.data ?? [];
    } catch (error) {
      hideLoading();
    } finally {
      hideLoading();
    }
  }
}