import 'dart:convert';
import 'package:get/get.dart';
import 'package:mypoint_flutter_app/networking/restful_api_client_all_request.dart';
import '../../networking/restful_api_viewmodel.dart';
import 'faqs_model.dart';

class FAQViewModel extends RestfulApiViewModel {
  var faqItems = <PageItemModel>[].obs;
  var isLoading = true.obs;

  @override
  void onInit() {
    super.onInit();
    fetchFAQItems();
  }

  Future<void> fetchFAQItems() async {
    showLoading();
    isLoading(true);
    client.websiteFolderGetPageList({"folder_uri": "FAQ"}).then((value) {
      hideLoading();
      isLoading(false);
      faqItems.value = value.data?.items ?? [];
    });
  }
}
