import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:get/get_core/src/get_main.dart';
import '../../../widgets/back_button.dart';
import '../models/game_bundle_item_model.dart';
import '../models/game_card_item_model.dart';

class GameCardScreen extends StatefulWidget {
  const GameCardScreen({super.key});
  @override
  State<GameCardScreen> createState() => _GameCardScreenState();
}
class _GameCardScreenState extends State<GameCardScreen> {
  late final GameBundleItemModel data;

  @override
  void initState() {
    super.initState();
    final args = Get.arguments;
    if (args is GameBundleItemModel) {
      data = args;
    }
  }

  @override
  Widget build(BuildContext context) {
    final cards = data.options ?? [];
    final screenHeight = MediaQuery.of(context).size.height;
    final startTop = screenHeight * 560 / 1920;

    return Scaffold(
      body: Stack(
        children: [
          // Background full màn
          Container(
            decoration: BoxDecoration(
              image: data.background != null
                  ? DecorationImage(image: NetworkImage(data.background!), fit: BoxFit.cover)
                  : null,
              color: Colors.green[100],
            ),
          ),
          // Button Back
          SafeArea(
            child: Padding(
              padding: const EdgeInsets.all(8),
              child: CustomBackButton(),
            ),
          ),
          Positioned(
            top: startTop,
            left: 16,
            right: 16,
            bottom: 0,
            child: GridView.builder(
              physics: const NeverScrollableScrollPhysics(),
              itemCount: cards.length,
              gridDelegate: const SliverGridDelegateWithFixedCrossAxisCount(
                crossAxisCount: 2,
                mainAxisSpacing: 20,
                crossAxisSpacing: 20,
                childAspectRatio: 3 / 4,
              ),
              itemBuilder: (context, index) {
                final card = cards[index];
                return GameCardItem(card: card);
              },
            ),
          ),
        ],
      ),
    );
  }
}

class GameCardItem extends StatelessWidget {
  final GameCardItemModel card;

  const GameCardItem({super.key, required this.card});

  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      onTap: () {
        print(card.id);
      },
      child: Container(
        decoration: BoxDecoration(
          color: Colors.white,
          borderRadius: BorderRadius.circular(18),
          boxShadow: [BoxShadow(color: Colors.black26, blurRadius: 4, offset: Offset(2, 2))],
        ),
        child: Column(
          mainAxisAlignment: MainAxisAlignment.center,
          children: [
            Expanded(
              child:
                  card.image != null
                      ? ClipRRect(
                        borderRadius: BorderRadius.circular(16),
                        child: Image.network(card.image!, fit: BoxFit.cover),
                      )
                      : const SizedBox(),
            ),
            const SizedBox(height: 6),
          ],
        ),
      ),
    );
  }
}
