import 'package:get/get_rx/src/rx_types/rx_types.dart';
import 'package:mypoint_flutter_app/networking/restful_api_client_all_request.dart';
import '../../networking/restful_api_viewmodel.dart';
import 'model/registration_form_package_model.dart';

class RegisterFormInputViewModel extends RestfulApiViewModel {
  var form = Rxn<RegistrationFormPackageModel>();
  var isLoading = false.obs;
  var isChecked = true.obs;

  Future<void> fetchRegisterFormInput(String id) async {
    try {
      isLoading.value = true;
      final response = await client.getRegistrationForm(id);
      form.value = response.data;
    } catch (error) {
      // onShowAlertError?.call("Error fetching product detail: $error");
      print("Error fetching product detail: $error");
    } finally {
      isLoading.value = false;
    }
  }
}