import 'package:mypoint_flutter_app/extensions/datetime_extensions.dart';
import 'package:mypoint_flutter_app/extensions/string_extension.dart';

enum SortFilter { asc, desc }

class HeaderFilterOrderModel {
  String title;
  SortFilter? sort;
  String? expired;
  double rateWidth;
  String suffixChecking;
  bool? selected;

  HeaderFilterOrderModel({
    required this.title,
    this.sort,
    this.expired,
    this.rateWidth = 1.0,
    required this.suffixChecking,
    this.selected,
  });

  Map<String, dynamic> get params {
    if (sort != null) {
      return {'order_checkup': sort!.name};
    }
    return {'expired': expired ?? ''};
  }

  String get eventNameTracking {
    if (sort == null) {
      return 'soskdt_${suffixChecking}';
    }
    return 'soskdt_${suffixChecking}_${sort!.name}';
  }

  String get eventNameTrackingDvCar => 'dvcar_${suffixChecking}';
}

class TrafficServiceResponseModel {
  int? total;
  List<TrafficServiceDetailModel>? products;

  TrafficServiceResponseModel({this.total, this.products});

  factory TrafficServiceResponseModel.fromJson(Map<String, dynamic> json) {
    return TrafficServiceResponseModel(
      total: json['total'],
      products: (json['products'] as List<dynamic>?)
          ?.map((e) => TrafficServiceDetailModel.fromJson(e))
          .toList(),
    );
  }

  Map<String, dynamic> toJson() => {
    'total': total,
    'products': products?.map((e) => e.toJson()).toList(),
  };
}

class TrafficServiceDetailModel {
  int? itemId;
  String? licensePlate;
  String? ownerName;
  String? phoneNumber;
  String? packageName;
  String? hotline;
  String? startTime;
  String? endTime;
  String? updatedAt;
  ButtonConfigModel? buyMoreNote;
  ActiveTextConfig? active;
  String? urlDownload;
  String? urlView;
  List<ProductMediaItem>? media;

  TrafficServiceDetailModel({
    this.itemId,
    this.licensePlate,
    this.ownerName,
    this.phoneNumber,
    this.packageName,
    this.hotline,
    this.startTime,
    this.endTime,
    this.updatedAt,
    this.buyMoreNote,
    this.active,
    this.urlDownload,
    this.urlView,
    this.media,
  });

  factory TrafficServiceDetailModel.fromJson(Map<String, dynamic> json) {
    return TrafficServiceDetailModel(
      itemId: json['item_id'],
      licensePlate: json['license_plate'],
      ownerName: json['owner_name'],
      phoneNumber: json['phone_number'],
      packageName: json['package_name'],
      hotline: json['hotline'],
      startTime: json['start_time'],
      endTime: json['end_time'],
      updatedAt: json['updated_at'],
      buyMoreNote: json['buy_more_note'] != null
          ? ButtonConfigModel.fromJson(json['buy_more_note'])
          : null,
      active: json['active'] != null
          ? ActiveTextConfig.fromJson(json['active'])
          : null,
      urlDownload: json['url_download'],
      urlView: json['url_view'],
      media: (json['media'] as List<dynamic>?)
          ?.map((e) => ProductMediaItem.fromJson(e))
          .toList(),
    );
  }

  Map<String, dynamic> toJson() => {
    'item_id': itemId,
    'license_plate': licensePlate,
    'owner_name': ownerName,
    'phone_number': phoneNumber,
    'package_name': packageName,
    'hotline': hotline,
    'start_time': startTime,
    'end_time': endTime,
    'updated_at': updatedAt,
    'buy_more_note': buyMoreNote?.toJson(),
    'active': active?.toJson(),
    'url_download': urlDownload,
    'url_view': urlView,
    'media': media?.map((e) => e.toJson()).toList(),
  };

  String get dateDes {
    final start = (startTime ?? '').toDate()?.toFormattedString() ?? '';
    final end = (endTime ?? '').toDate()?.toFormattedString() ?? '';
    return '$start - $end';
  }
}

class ActiveTextConfig {
  String? text;
  String? textColor;
  String? bgColor;

  ActiveTextConfig({this.text, this.textColor, this.bgColor});

  factory ActiveTextConfig.fromJson(Map<String, dynamic> json) {
    return ActiveTextConfig(
      text: json['text'],
      textColor: json['text_color'],
      bgColor: json['bg_color'],
    );
  }

  Map<String, dynamic> toJson() => {
    'text': text,
    'text_color': textColor,
    'bg_color': bgColor,
  };
}

class ProductMediaItem {
  String? name;
  String? url;
  String? rawType;

  ProductMediaItem({this.name, this.url, this.rawType});

  factory ProductMediaItem.fromJson(Map<String, dynamic> json) {
    return ProductMediaItem(
      name: json['name'],
      url: json['url'],
      rawType: json['type'],
    );
  }

  Map<String, dynamic> toJson() => {
    'name': name,
    'url': url,
    'type': rawType,
  };

  String? get type => rawType;
}

class ButtonConfigModel {
  String? text;
  String? action;

  ButtonConfigModel({this.text, this.action});

  factory ButtonConfigModel.fromJson(Map<String, dynamic> json) {
    return ButtonConfigModel(
      text: json['text'],
      action: json['action'],
    );
  }

  Map<String, dynamic> toJson() => {
    'text': text,
    'action': action,
  };
}