import 'package:json_annotation/json_annotation.dart';
import 'package:mypoint_flutter_app/screen/transaction/model/payment_method_type.dart';

part 'payment_method_model.g.dart';
@JsonSerializable()
class PaymentMethodModel {
  final int? id;
  final String? code;
  final String? name;
  final String? logo;
  @JsonKey(name: 'save_token')
  final bool? saveToken;
  final bool? isSelected;
  bool? needSaveTokenWhenOrder;

  PaymentMethodType? get type {
    if (code == null) return null;
    try {
      return PaymentMethodType.fromString(code!);
    } catch (_) {
      return null;
    }
  }

  PaymentMethodModel({
    this.id,
    this.code,
    this.name,
    this.logo,
    this.saveToken,
    this.isSelected,
    this.needSaveTokenWhenOrder,
  });

  factory PaymentMethodModel.fromJson(Map<String, dynamic> json) =>
      _$PaymentMethodModelFromJson(json);
  Map<String, dynamic> toJson() => _$PaymentMethodModelToJson(this);
}
