import '../../mobile_card/models/product_mobile_card_model.dart';

class MyVoucherResponse {
  final int? listStart;
  final int? listLimit;
  final int? listTotal;
  final List<ProductMobileCardModel>? listItems;

  MyVoucherResponse({
    this.listStart,
    this.listLimit,
    this.listTotal,
    this.listItems,
  });

  factory MyVoucherResponse.fromJson(Map<String, dynamic> json) {
    return MyVoucherResponse(
      listStart: json['list_start'] as int?,
      listLimit: json['list_limit'] as int?,
      listTotal: json['list_total'] as int?,
      listItems: (json['list_items'] as List<dynamic>?)
          ?.map((e) => ProductMobileCardModel.fromJson(e as Map<String, dynamic>))
          .toList(),
    );
  }

  Map<String, dynamic> toJson() {
    return {
      'list_start': listStart,
      'list_limit': listLimit,
      'list_total': listTotal,
      'list_items': listItems?.map((e) => e.toJson()).toList(),
    };
  }
}