import 'package:json_annotation/json_annotation.dart';
import 'package:mypoint_flutter_app/extensions/date_format.dart';
import 'package:mypoint_flutter_app/extensions/datetime_extensions.dart';
import 'package:mypoint_flutter_app/extensions/string_extension.dart';
import 'package:mypoint_flutter_app/screen/voucher/models/product_brand_model.dart';
import 'package:mypoint_flutter_app/screen/voucher/models/product_content_model.dart';
import 'package:mypoint_flutter_app/screen/voucher/models/product_customer_info_model.dart';
import 'package:mypoint_flutter_app/screen/voucher/models/product_item_model.dart';
import 'package:mypoint_flutter_app/screen/voucher/models/product_media_item.dart';
import 'package:mypoint_flutter_app/screen/voucher/models/product_price_model.dart';
import 'package:mypoint_flutter_app/screen/voucher/models/product_properties_model.dart';
import 'package:mypoint_flutter_app/screen/voucher/models/product_type.dart';
import '../../flash_sale/preview_flash_sale_model.dart';
import 'media_type.dart';
import 'my_product_status_type.dart';

part 'product_model.g.dart';

@JsonSerializable()
class ProductModel {
  final int? id;
  @JsonKey(name: 'like_id')
  int? likeId;
  @JsonKey(name: 'quantity_available')
  final int? quantityAvailable;
  final ProductContentModel? content;
  final ProductPriceModel? price;
  final ProductBrandModel? brand;
  @JsonKey(name: 'voucher_properties')
  final ProductPropertiesModel? properties;
  final List<ProductMediaItem>? media;
  @JsonKey(name: 'preview_campaign')
  final ProductPreviewCampaignModel? previewCampaign;
  @JsonKey(name: 'preview_campaign_flash_sale')
  final PreviewFlashSale? previewFlashSale;
  @JsonKey(name: 'customer_product_info')
  final ProductCustomerInfoModel? customerInfoModel;
  @JsonKey(name: 'product_item')
  final ProductItemModel? item;
  @JsonKey(name: 'expire_time')
  final String? expireTime;
  @JsonKey(name: 'require_form_regis')
  final bool? requireFormRegis;
  final String? type;

  ProductModel({
    this.id,
    this.likeId,
    this.quantityAvailable,
    this.content,
    this.price,
    this.brand,
    this.properties,
    this.media,
    this.previewCampaign,
    this.previewFlashSale,
    this.customerInfoModel,
    this.item,
    this.expireTime,
    this.requireFormRegis,
    this.type,
  });

  String? get name {
    return content?.name;
  }

  int? get percentDiscount {
    if (previewFlashSale?.isFlashSalePrice == true) {
      return previewFlashSale?.percentTag;
    }
    return null;
  }

  ProductType get productType {
    return ProductTypeExt.from(type) ?? ProductType.voucher;
  }

  String get expire {
    final ex = (isMyProduct ? item?.expireTime : expireTime) ?? "";
    return ex.toDate()?.toFormattedString() ?? "";
  }

  bool get expired {
    if (customerInfoModel?.status == MyProductStatusType.expired) return true;
    final expireDate = expire.toDateFormat('dd/MM/yyyy');
    if (expireDate == null) return false;
    return expireDate!.isBefore(DateTime.now());
  }

  int? get amountToBePaid {
    if (previewFlashSale?.isFlashSalePrice == true) {
      return previewFlashSale?.price;
    }
    return price?.value;
  }

  bool get isMyProduct {
    return customerInfoModel != null;
  }

  bool get inStock {
    return (quantityAvailable ?? 1) != 0;
  }

  bool get liked {
    return (likeId ?? 0) != 0;
  }

  ProductMediaItem? get banner {
    if (media == null) return null;
    return media!.firstWhere((item) => item.type == MediaType.banner16_9, orElse: () => media!.first);
  }

  double get progress {
    if (previewFlashSale?.fsQuantityTotal != null &&
        previewFlashSale?.fsQuantitySold != null &&
        previewFlashSale!.fsQuantityTotal! > 0) {
      return previewFlashSale!.fsQuantitySold! / previewFlashSale!.fsQuantityTotal!;
    }
    return 0.0;
  }

  bool get isShowProsessSoldItem {
    return previewFlashSale?.isFlashSale == true && (previewFlashSale?.fsQuantityTotal ?? 0) > 0;
  }

  double get extendSpaceFlashSaleItem {
    double heightPrice = 24;
    double heightName = 36;
    double space = 4;
    double extend = heightPrice + heightName + space * 5;
    if (previewFlashSale?.rewardContent != null) {
      extend += space;
      extend += 30;
    }
    if (isShowProsessSoldItem) {
      extend += space;
      extend += 18;
    }
    print("extendSpaceFlashSaleItem $extend");
    return extend;
  }

  factory ProductModel.fromJson(Map<String, dynamic> json) => _$ProductModelFromJson(json);

  Map<String, dynamic> toJson() => _$ProductModelToJson(this);
}

@JsonSerializable()
class ProductPreviewCampaignModel {
  @JsonKey(name: 'reward_point')
  int? rewardPoint;
  @JsonKey(name: 'has_gift')
  bool? hasGift;

  ProductPreviewCampaignModel({
    this.rewardPoint,
    this.hasGift,
  });

  factory ProductPreviewCampaignModel.fromJson(Map<String, dynamic> json) => _$ProductPreviewCampaignModelFromJson(json);
  Map<String, dynamic> toJson() => _$ProductPreviewCampaignModelToJson(this);
}
