import 'package:flutter/material.dart';
import 'package:get/get.dart';
import '../../../shared/router_gage.dart';
import '../../../widgets/custom_empty_widget.dart';
import '../../../widgets/custom_navigation_bar.dart';
import '../../../widgets/custom_search_navigation_bar.dart';
import '../../transaction/history/transaction_history_detail_screen.dart';
import '../sub_widget/voucher_item_list.dart';
import 'voucher_list_viewmodel.dart';

class VoucherListScreen extends StatefulWidget {
  const VoucherListScreen({super.key});

  @override
  _VoucherListScreenState createState() => _VoucherListScreenState();
}

class _VoucherListScreenState extends State<VoucherListScreen> {
  late final Map<String, dynamic> args;
  late final bool enableSearch;
  late final bool isHotProduct;
  late final bool isFavorite;
  late final VoucherListViewModel _viewModel;

  @override
  void initState() {
    super.initState();
    args = Get.arguments ?? {};
    enableSearch = args['enableSearch'] ?? false;
    isHotProduct = args['isHotProduct'] ?? false;
    isFavorite = args['favorite'] ?? false;
    _viewModel = Get.put(VoucherListViewModel(isHotProduct: isHotProduct, isFavorite: isFavorite));
  }

  @override
  Widget build(BuildContext context) {
    final String title = isFavorite ? 'Yêu thích' : (isHotProduct ? 'Săn ưu đãi' : 'Tất cả ưu đãi');
    return Scaffold(
      appBar:
          enableSearch
              ? CustomSearchNavigationBar(onSearchChanged: _viewModel.onSearchChanged,)
              : CustomNavigationBar(title: title),
      body: Column(
        children: [
          if (enableSearch)
            Padding(
              padding: const EdgeInsets.symmetric(horizontal: 16, vertical: 12),
              child: Obx(() {
                final resultCount = _viewModel.totalResult.value;
                final displayText = _viewModel.searchQuery.isNotEmpty
                    ? '$title ($resultCount kết quả)'
                    : title;
                return Align(
                alignment: Alignment.centerLeft,
                  child: Text(
                    displayText,
                    style: const TextStyle(
                      fontSize: 16,
                      fontWeight: FontWeight.w600,
                    ),
                  ),
                );
              }),
            ),
          Expanded(
            child: Obx(
              () {
                if (_viewModel.products.isEmpty) {
                  return const Center(
                    child: EmptyWidget(),
                  );
                }
                return RefreshIndicator(
                  onRefresh: () => _viewModel.loadData(reset: true),
                  child: ListView.builder(
                    physics: const AlwaysScrollableScrollPhysics(),
                    itemCount: _viewModel.products.length + (_viewModel.hasMore ? 1 : 0),
                    itemBuilder: (context, index) {
                      if (index >= _viewModel.products.length) {
                        _viewModel.loadData(reset: false);
                        return const Center(
                          child: Padding(padding: EdgeInsets.all(16), child: CircularProgressIndicator()),
                        );
                      }
                      final product = _viewModel.products[index];
                      return GestureDetector(
                        onTap: () async {
                          await Get.toNamed(voucherDetailScreen, arguments: {"productId": product.id});
                          _viewModel.loadData(reset: true);
                        },
                        child: VoucherListItem(product: product),
                      );
                    },
                  ),
                );
              }
            ),
          ),
        ],
      ),
    );
  }
}