import 'package:flutter/material.dart';
import 'package:get/get.dart';
import '../screen/home/header_home_viewmodel.dart';
import 'back_button.dart';
import 'image_loader.dart';

class CustomNavigationBar extends StatelessWidget implements PreferredSizeWidget {
  final String title;
  final String? backgroundImage;
  final List<Widget> leftButtons;
  final List<Widget> rightButtons;
  final _defaultBgImage = 'assets/images/bg_header_navi.png';

  const CustomNavigationBar({
    super.key,
    required this.title,
    this.backgroundImage,
    this.leftButtons = const [CustomBackButton()],
    this.rightButtons = const [],
  });

  @override
  Size get preferredSize => const Size.fromHeight(kToolbarHeight);

  @override
  Widget build(BuildContext context) {
    if (backgroundImage != null && backgroundImage!.isNotEmpty) {
      return _buildAppBar(backgroundImage!, context);
    }

    final theme = Get.find<HeaderThemeController>();
    return Obx(() {
      final bg = theme.background.value ?? _defaultBgImage;
      return _buildAppBar(bg, context);
    });
  }

  Widget _buildAppBar(String bgImage, BuildContext context) {
    final double statusBarHeight = MediaQuery.of(context).padding.top;
    final bool isHttp = bgImage.startsWith('http://') || bgImage.startsWith('https://');
    final paddingTitle = (leftButtons.isNotEmpty || rightButtons.isNotEmpty) ? 48.0 : 16.0; // cách 2 đầu
    return Container(
        height: statusBarHeight + kToolbarHeight,
        decoration: BoxDecoration(
          color: bgImage.isEmpty ? Colors.white : null,
        ),
        child: Stack(
          fit: StackFit.expand,
          children: [
            if (bgImage.isNotEmpty)
              isHttp
                  ? loadNetworkImage(
                url: bgImage,
                fit: BoxFit.cover,
                placeholderAsset: _defaultBgImage,
              )
                  : Image.asset(_defaultBgImage, fit: BoxFit.cover),
            SafeArea(
              bottom: false,
              child: Stack(
                alignment: Alignment.center,
                children: [
                  Padding(
                    padding: EdgeInsets.symmetric(horizontal: paddingTitle),
                    child: FittedBox(
                      fit: BoxFit.scaleDown, // tự giảm font để vừa khung
                      child: Text(
                        title,
                        maxLines: 1,
                        softWrap: false,
                        overflow: TextOverflow.visible, // không dùng ellipsis
                        textAlign: TextAlign.center,
                        style: const TextStyle(
                          fontSize: 18,                 // cỡ tối đa
                          fontWeight: FontWeight.w800,
                          color: Colors.white,
                        ),
                      ),
                    ),
                  ),
                  // Text(
                  //   title,
                  //   maxLines: 1,
                  //   style: const TextStyle(fontSize: 18, fontWeight: FontWeight.w800, color: Colors.white),
                  //   textAlign: TextAlign.center,
                  // ),
                  // Buttons bên trái
                  if (leftButtons.isNotEmpty)
                    Positioned(left: 12, child: Row(mainAxisSize: MainAxisSize.min, children: leftButtons)),
                  // Buttons bên phải
                  if (rightButtons.isNotEmpty)
                    Positioned(right: 12, child: Row(mainAxisSize: MainAxisSize.min, children: rightButtons)),
                ],
              ),
            ),
          ],
        ),
      );
  }
}
