import 'package:shared_preferences/shared_preferences.dart';

class ContactStorageService {
  static const _keyUsedContacts = 'used_contacts';

  /// Lưu 1 số điện thoại vào danh sách đã dùng
  Future<void> saveUsedContact(String phone) async {
    final prefs = await SharedPreferences.getInstance();
    final list = prefs.getStringList(_keyUsedContacts) ?? [];
    /// Nếu chưa có thì thêm vào đầu
    if (!list.contains(phone)) {
      list.add(phone);
      await prefs.setStringList(_keyUsedContacts, list);
    }
  }

  /// Lấy danh sách số đã dùng
  Future<List<String>> getUsedContacts() async {
    final prefs = await SharedPreferences.getInstance();
    return prefs.getStringList(_keyUsedContacts) ?? [];
  }

  /// Xóa toàn bộ danh sách đã dùng (nếu cần)
  Future<void> clearUsedContacts() async {
    final prefs = await SharedPreferences.getInstance();
    await prefs.remove(_keyUsedContacts);
  }
}
