import 'package:json_annotation/json_annotation.dart';
import 'game_bundle_item_model.dart';

part 'game_bundle_response.g.dart';
@JsonSerializable()
class GameBundleResponse {
  @JsonKey(name: 'turns_number_text')
  final String? turnsNumberText;

  final List<GameBundleItemModel>? games;

  GameBundleResponse({
    this.turnsNumberText,
    this.games,
  });

  factory GameBundleResponse.fromJson(Map<String, dynamic> json) => _$GameBundleResponseFromJson(json);

  Map<String, dynamic> toJson() => _$GameBundleResponseToJson(this);
}
