import 'package:json_annotation/json_annotation.dart';
import '../../flash_sale/preview_flash_sale_model.dart';
import '../../voucher/models/product_model.dart';

part 'flash_sale_model.g.dart';

@JsonSerializable()
class FlashSaleModel {
  final int id;
  final String? name;
  @JsonKey(name: 'start_time')
  final String? startTime;
  @JsonKey(name: 'end_time')
  final String? endTime;
  @JsonKey(name: 'header_img')
  final String? headerImg;
  @JsonKey(name: 'countdown_second')
  final int? countdownSecond;
  final List<ProductModel>? products;

  const FlashSaleModel({
    required this.id,
    this.name,
    this.startTime,
    this.endTime,
    this.headerImg,
    this.countdownSecond,
    this.products,
  });

  factory FlashSaleModel.fromJson(Map<String, dynamic> json) => _$FlashSaleModelFromJson(json);
  Map<String, dynamic> toJson() => _$FlashSaleModelToJson(this);

  PreviewFlashSale get info {
    final info =
        products?.first?.previewFlashSale ??
        PreviewFlashSale(
          id: id,
          countdownSecond: countdownSecond,
          startTime: startTime,
          endTime: endTime,
          name: name,
          headerImg: headerImg,
        );
    info.headerImg = headerImg;
    return info;
  }
}
