import 'package:get/get_rx/src/rx_types/rx_types.dart';
import 'package:mypoint_flutter_app/configs/constants.dart';
import 'package:mypoint_flutter_app/networking/restful_api_client_all_request.dart';
import '../../networking/restful_api_viewmodel.dart';
import 'models/invite_friend_campaign_model.dart';

class InviteFriendCampaignViewModel extends RestfulApiViewModel {
  var inviteFriendDetail = Rxn<InviteFriendDetailModel>();
  var campaignDetail = Rxn<CampaignInviteFriendDetail>();
  void Function(String message, bool onBack)? onShowAlertError;
  void Function(String, String)? phoneInviteFriendResponse;

  loadData() {
    _getInviteFriendDetail();
    _getCampaignInviteFriendDetail();
  }

  Future<void> phoneInviteFriend(String phone) async {
    showLoading();
    try {
      final response = await client.phoneInviteFriend(phone);
      hideLoading();
      final sms = response.data?.sms ?? '';
      if (response.isSuccess && sms.isNotEmpty) {
        phoneInviteFriendResponse?.call(sms, phone);
      } else {
        onShowAlertError?.call(response.errorMessage ?? Constants.commonError, false);
      }
    } catch (error) {
      hideLoading();
      onShowAlertError?.call(Constants.commonError, false);
    }
  }

    Future<void> _getInviteFriendDetail() async {
      showLoading();
      try {
      final response = await client.getCampaignInviteFriend();
      hideLoading();
      inviteFriendDetail.value = response.data;
      if (!response.isSuccess) {
        onShowAlertError?.call(response.errorMessage ?? Constants.commonError, true);
      }
    } catch (error) {
      onShowAlertError?.call(Constants.commonError, true);
    } finally {
      hideLoading();
    }
  }

  Future<void> _getCampaignInviteFriendDetail() async {
    try {
      final response = await client.getDetailCampaignInviteFriend();
      campaignDetail.value = response.data;
    } catch (_) {}
  }
}
