import 'dart:core';
import 'package:json_annotation/json_annotation.dart';
import 'package:mypoint_flutter_app/screen/transaction/model/preview_order_payment_point_data_model.dart';
import 'package:mypoint_flutter_app/screen/transaction/model/preview_order_product_info_model.dart';

part 'preview_order_payment_model.g.dart';
@JsonSerializable()
class PreviewOrderPaymentModel {
  @JsonKey(name: 'total_cash_coupon')
  final int? totalCashCoupon;
  @JsonKey(name: 'fees_price')
  final int? feesPrice;
  @JsonKey(name: 'total_cash')
  final int? totalCash;
  @JsonKey(name: 'fee_note')
  final String? feeNote;
  @JsonKey(name: 'point_data')
  final PreviewOrderPaymentPointDataModel? pointData;
  @JsonKey(name: 'product_info')
  final List<PreviewOrderProductInfoModel>? productInfo;
  @JsonKey(name: 'total_price')
  final int? totalPrice;
  @JsonKey(name: 'discount_coupon_value')
  final int? discountCouponValue;
  @JsonKey(name: 'payment_method')
  final String? paymentMethod;
  @JsonKey(name: 'product_type')
  final String? productType;

  PreviewOrderPaymentModel({
    this.totalCashCoupon,
    this.feesPrice,
    this.totalCash,
    this.feeNote,
    this.pointData,
    this.productInfo,
    this.totalPrice,
    this.discountCouponValue,
    this.paymentMethod,
    this.productType,
  });

  factory PreviewOrderPaymentModel.fromJson(Map<String, dynamic> json) =>
      _$PreviewOrderPaymentModelFromJson(json);
  Map<String, dynamic> toJson() => _$PreviewOrderPaymentModelToJson(this);
}
