// Stub implementations for non-web platforms

void webReplaceUrl(String path) {
  // no-op on non-web
}

void webClearStorage() {
  // no-op on non-web
}

/// Get token from app host via x-app-sdk
String? webGetAppHostToken() {
  return null;
}

/// Get user info from app host via x-app-sdk
Map<String, dynamic>? webGetAppHostUser() {
  return null;
}

/// Check if app host data is ready
bool webIsAppHostDataReady() {
  return false;
}

/// Get error message from app host
String? webGetAppHostError() {
  return null;
}

/// Initialize x-app-sdk service
Future<void> webInitializeXAppSDK() async {
  // no-op on non-web
}

/// Store app host data
void webStoreAppHostData(String token, Map<String, dynamic>? user) {
  // no-op on non-web
}

/// Clear app host data
void webClearAppHostData() {
  // no-op on non-web
}

/// Execute JavaScript in the web context
Future<dynamic> webExecuteJavaScript(String script) async {
  return null;
}

/// Call x-app-sdk method if available
Future<dynamic> webCallXAppSDKMethod(String methodName, [List<dynamic>? args]) async {
  return null;
}

/// Get user info by key from app host
Future<dynamic> webGetUserInfoByKey(String key) async {
  return null;
}

/// Get token asynchronously from app host
Future<String?> webGetTokenAsync() async {
  return null;
}

/// Check if x-app-sdk is available from Super App
bool webIsSDKAvailable() {
  return false;
}

/// Close app and return to Super App
void webCloseApp([Map<String, dynamic>? data]) {
  // no-op on non-web
}


