# Close App Integration

## Tổng quan

Tính năng `closeApp` cho phép web app đóng ứng dụng và trả về Super App với dữ liệu tùy chọn.

## Cách sử dụng

### 1. Import cần thiết

```dart
import 'package:flutter/foundation.dart';
import 'package:mypoint_flutter_app/web/web_helper.dart';
```

### 2. Các cách gọi closeApp

#### Đóng app đơn giản (không trả về dữ liệu)
```dart
if (kIsWeb) {
  webCloseApp();
}
```

#### Đóng app với dữ liệu thành công
```dart
if (kIsWeb) {
  webCloseApp({
    'result': 'success',
    'message': 'Operation completed successfully',
    'timestamp': DateTime.now().millisecondsSinceEpoch,
  });
}
```

#### Đóng app với dữ liệu lỗi
```dart
if (kIsWeb) {
  webCloseApp({
    'result': 'error',
    'message': 'Something went wrong',
    'timestamp': DateTime.now().millisecondsSinceEpoch,
  });
}
```

#### Đóng app với dữ liệu tùy chỉnh
```dart
if (kIsWeb) {
  webCloseApp({
    'result': 'custom',
    'data': {
      'userId': '12345',
      'action': 'completed',
      'metadata': {'key': 'value'}
    },
    'timestamp': DateTime.now().millisecondsSinceEpoch,
  });
}
```

### 3. Ví dụ thực tế

#### Sau khi thanh toán thành công
```dart
void onPaymentSuccess(String transactionId, double amount) {
  if (kIsWeb) {
    webCloseApp({
      'result': 'payment_success',
      'transactionId': transactionId,
      'amount': amount,
      'currency': 'VND',
      'timestamp': DateTime.now().millisecondsSinceEpoch,
    });
  }
}
```

#### Sau khi submit form
```dart
void onFormSubmitted(Map<String, dynamic> formData) {
  if (kIsWeb) {
    webCloseApp({
      'result': 'form_submitted',
      'formType': 'registration',
      'formData': formData,
      'timestamp': DateTime.now().millisecondsSinceEpoch,
    });
  }
}
```

#### Khi người dùng hủy thao tác
```dart
void onUserCancel() {
  if (kIsWeb) {
    webCloseApp({
      'result': 'cancelled',
      'message': 'User cancelled the operation',
      'timestamp': DateTime.now().millisecondsSinceEpoch,
    });
  }
}
```

## Cấu trúc dữ liệu trả về

### Format chuẩn
```dart
{
  'result': String,        // 'success', 'error', 'cancelled', 'custom', etc.
  'message': String?,      // Thông báo mô tả (optional)
  'data': dynamic?,        // Dữ liệu tùy chỉnh (optional)
  'timestamp': int,        // Timestamp (milliseconds)
  // ... các field khác tùy theo use case
}
```

### Ví dụ các loại result
- `success`: Thao tác thành công
- `error`: Có lỗi xảy ra
- `cancelled`: Người dùng hủy
- `payment_success`: Thanh toán thành công
- `form_submitted`: Form đã submit
- `custom`: Dữ liệu tùy chỉnh

## Fallback behavior

Nếu Super App không cung cấp `closeApp` function:
1. Sẽ thử `window.history.back()` để quay lại trang trước
2. Nếu không có history, sẽ thử `window.close()` để đóng tab/window
3. Log warning trong console

## Testing

### Test với URL parameters
```bash
# Mở app với dữ liệu test
http://localhost:8080/?token=test123&user={"id":"user123"}
```

### Test trong Super App
- Đảm bảo Super App đã implement `closeApp` function
- Kiểm tra console log để xem dữ liệu được trả về

## Lưu ý

1. **Chỉ hoạt động trên web**: Function `webCloseApp` chỉ hoạt động khi `kIsWeb = true`
2. **Kiểm tra platform**: Luôn kiểm tra `kIsWeb` trước khi gọi
3. **Error handling**: Function có built-in error handling và fallback
4. **Logging**: Tất cả hoạt động đều được log để debug

## Files liên quan

- `lib/web/web_helper_web.dart` - Implementation cho web
- `lib/web/web_helper_stub.dart` - Stub cho non-web platforms  
- `web/index.html` - JavaScript implementation
- `lib/web/close_app_example.dart` - Ví dụ sử dụng
