import 'package:flutter/foundation.dart';
import 'package:flutter/material.dart';
import 'package:flutter_localizations/flutter_localizations.dart';
import 'package:get/get.dart';
import 'package:mypoint_flutter_app/base/app_navigator.dart';
import 'package:mypoint_flutter_app/resources/base_color.dart';
import 'package:mypoint_flutter_app/screen/splash/splash_screen.dart';
import 'package:mypoint_flutter_app/shared/router_gage.dart';
import 'package:mypoint_flutter_app/core/app_initializer.dart';
import 'package:flutter_web_plugins/url_strategy.dart';

final RouteObserver<PageRoute> routeObserver = RouteObserver<PageRoute>();

void main() async {
  WidgetsFlutterBinding.ensureInitialized();
  if (kIsWeb) {
    setUrlStrategy(PathUrlStrategy());
  }
  // Initialize all app features
  await AppInitializer.initialize();
  // Run the app
  runApp(const MyApp());
  // Setup post-initialization callbacks
  AppInitializer.setupPostInitCallbacks();
}


class MyApp extends StatelessWidget {
  const MyApp({super.key});

  @override
  Widget build(BuildContext context) {
    return GetMaterialApp(
      navigatorKey: AppNavigator.key,
      navigatorObservers: [routeObserver],
      debugShowCheckedModeBanner: false,
      // initialRoute: '/splash',
      theme: ThemeData(
        colorScheme: ColorScheme.fromSwatch(primarySwatch: Colors.brown),
        primaryColor: BaseColor.primary500,
      ),
      locale: const Locale('vi'),
      supportedLocales: const [
        Locale('vi', 'VN'), // Vietnamese
      ],
      localizationsDelegates: const [
        GlobalMaterialLocalizations.delegate,
        GlobalWidgetsLocalizations.delegate,
        GlobalCupertinoLocalizations.delegate,
      ],
      home: SplashScreen(),
      getPages: RouterPage.pages(),
    );
  }
}
