// profile_response_model.dart
import 'package:json_annotation/json_annotation.dart';
import 'working_site_model.dart';
import 'worker_site_model.dart';
import 'user_agreement_model.dart';

part 'profile_response_model.g.dart';
@JsonSerializable()
class ProfileResponseModel {
  @JsonKey(name: 'worker_site')
  final WorkerSiteModel? workerSite;

  @JsonKey(name: 'working_site')
  final WorkingSiteModel? workingSite;

  @JsonKey(name: 'user_agreements')
  final UserAgreementModel? userAgreements;

  @JsonKey(name: 'force_reset_password')
  String? forceResetPassword;

  @JsonKey(name: 'remaining_login_fail')
  final String? remainingLoginFail;

  @JsonKey(name: 'unlock_after_time')
  final String? unlockAfter;

  ProfileResponseModel({
    this.workerSite,
    this.workingSite,
    this.userAgreements,
    this.forceResetPassword,
    this.remainingLoginFail,
    this.unlockAfter,
  });

  factory ProfileResponseModel.fromJson(Map<String, dynamic> json) => _$ProfileResponseModelFromJson(json);
  Map<String, dynamic> toJson() => _$ProfileResponseModelToJson(this);
}


