// Web-specific implementations for x-app-sdk
// ignore: avoid_web_libraries_in_flutter
import 'dart:convert';
import 'package:universal_html/html.dart' as html;
import 'x_app_sdk_service.dart';

/// Web-specific helper functions for x-app-sdk integration

/// Initialize x-app-sdk service
Future<void> webInitializeXAppSDK() async {
  try {
    await XAppSDKService().initialize();
  } catch (e) {
    print('❌ Error initializing x-app-sdk: $e');
  }
}

/// Get token from x-app-sdk
Future<String?> webGetToken() async {
  try {
    return await XAppSDKService().getToken();
  } catch (e) {
    print('❌ Error getting token: $e');
    return null;
  }
}

/// Close app and return to Super App
Future<void> webCloseApp([Map<String, dynamic>? data]) async {
  try {
    await XAppSDKService().closeApp(data);
  } catch (e) {
    print('❌ Error closing app: $e');
  }
}

/// Check if x-app-sdk is initialized
bool webIsSDKInitialized() {
  try {
    return XAppSDKService().isInitialized;
  } catch (e) {
    print('❌ Error checking SDK status: $e');
    return false;
  }
}

/// Get cached token
String? webGetCachedToken() {
  try {
    return XAppSDKService().cachedToken;
  } catch (e) {
    print('❌ Error getting cached token: $e');
    return null;
  }
}

/// Get last error message
String? webGetLastError() {
  try {
    return XAppSDKService().lastError;
  } catch (e) {
    print('❌ Error getting last error: $e');
    return null;
  }
}

/// Clear token cache
void webClearTokenCache() {
  try {
    XAppSDKService().clearToken();
  } catch (e) {
    print('❌ Error clearing token cache: $e');
  }
}

/// Reset SDK service
void webResetSDK() {
  try {
    XAppSDKService().reset();
  } catch (e) {
    print('❌ Error resetting SDK: $e');
  }
}
