# x-app-sdk

## Giới thiệu
`x-app-sdk` là một thư viện hỗ trợ phát triển ứng dụng với các tính năng tương tác với `superapp`.
SDK với dữ liệu thật chỉ được trả ra khi chạy trên Super App. Khi chạy trên web thường sẽ có những data mẫu có cấu trúc tương tự data thật.

## Cài đặt
Bạn có thể cài đặt `x-app-sdk` bằng npm:
```sh
npm install x-app-sdk
```
Hoặc sử dụng yarn:
```sh
yarn add x-app-sdk
```

## Các tính năng chính

### 1. Config - Cấu hình ứng dụng
#### `configUIApp(config)`
Cấu hình giao diện ứng dụng trong SuperApp.
```js
import { configUIApp, IViewUiConfig } from 'x-app-sdk';

const config: IViewUiConfig = {
    headerTitle: 'Tên ứng dụng',
    headerColor: '#ffffff',
    headerTextColor: '#000000'
    headerSubTitle: 'Mô tả ngắn ứng dụng';    // optional
    headerIcon: 'Link icon trên header';    // optional
};

configUIApp(config).then(response => {
    console.log('Cấu hình thành công:', response);
}).catch(error => {
    console.error('Lỗi cấu hình:', error);
});
```

### 2. Device - Tương tác thiết bị
#### `call(phoneNumber)`
Thực hiện cuộc gọi đến số điện thoại.
```js
import { call } from 'x-app-sdk';

call('0123456789').then(() => {
    console.log('Bắt đầu cuộc gọi');
}).catch(error => {
    console.error('Lỗi cuộc gọi:', error);
});
```

#### `sms(phoneNumber)`
Mở ứng dụng tin nhắn với số điện thoại.
```js
import { sms } from 'x-app-sdk';

sms('0123456789').then(() => {
    console.log('Mở ứng dụng tin nhắn');
}).catch(error => {
    console.error('Lỗi tin nhắn:', error);
});
```

#### `vibrate()`
Kích hoạt rung thiết bị.
```js
import { vibrate } from 'x-app-sdk';

vibrate().then(() => {
    console.log('Thiết bị rung');
}).catch(error => {
    console.error('Lỗi rung:', error);
});
```

### 3. Location - Dịch vụ vị trí
#### `currentLocation()`
Lấy vị trí hiện tại của thiết bị.
```js
import { currentLocation } from 'x-app-sdk';

currentLocation().then(location => {
    console.log('Vị trí hiện tại:', location.data);
}).catch(error => {
    console.error('Lỗi lấy vị trí:', error);
});
```

#### `requestLocationPermission()`
Yêu cầu quyền truy cập vị trí.
```js
import { requestLocationPermission } from 'x-app-sdk';

requestLocationPermission().then(response => {
    console.log('Quyền vị trí:', response);
}).catch(error => {
    console.error('Lỗi quyền vị trí:', error);
});
```

### 4. Media - Xử lý phương tiện
#### `openPickerImage(type)`
Mở trình chọn ảnh từ thiết bị.
```js
import { openPickerImage, EMediaType } from 'x-app-sdk';

openPickerImage(EMediaType.GALLERY).then(imageData => {
    console.log('Dữ liệu ảnh:', imageData.data);
}).catch(error => {
    console.error('Lỗi chọn ảnh:', error);
});
```

#### `openPickerFile()`
Mở trình chọn file từ thiết bị.
```js
import { openPickerFile } from 'x-app-sdk';

openPickerFile().then(fileData => {
    console.log('Dữ liệu file:', fileData.data);
}).catch(error => {
    console.error('Lỗi chọn file:', error);
});
```

### 5. Notification - Thông báo
#### `listenNotifiactionEvent(callback)`
Lắng nghe các sự kiện thông báo từ SuperApp.
```js
import { listenNotifiactionEvent } from 'x-app-sdk';

const unsubscribe = listenNotifiactionEvent((data) => {
    console.log('Thông báo mới:', data);
});

// Để hủy lắng nghe
unsubscribe();
```

### 6. Payment - Thanh toán
#### `paymentRequest(body)`
Thực hiện yêu cầu thanh toán qua SuperApp.
```js
import { paymentRequest } from 'x-app-sdk';

const paymentData = {
    partnerOrderId: "ORDER123";
    totalAmount: 100000;
    extra: "JSON data, string...."; // optional
};

paymentRequest(paymentData).then(result => {
    console.log('Kết quả thanh toán:', result.data);
}).catch(error => {
    console.error('Lỗi thanh toán:', error);
});
```

#### `listenPaymentEvent(callback)`
Lắng nghe các sự kiện thanh toán.
```js
import { listenPaymentEvent } from 'x-app-sdk';

const unsubscribe = listenPaymentEvent((data) => {
    console.log('Sự kiện thanh toán:', data);
});

// Để hủy lắng nghe
unsubscribe();
```

### 7. Permission - Quyền truy cập
#### `premissionsRequest(type)`
Yêu cầu quyền truy cập cho một tính năng cụ thể.
```js
import { premissionsRequest, ETypeRequest } from 'x-app-sdk';

premissionsRequest(ETypeRequest.RequestPickerImage).then(granted => {
    if (granted.data) {
        console.log('Quyền được cấp');
    } else {
        console.log('Quyền bị từ chối');
    }
}).catch(error => {
    console.error('Lỗi kiểm tra quyền:', error);
});
```

### 8. Routing - Điều hướng
#### `closeApp(data?)`
Đóng ứng dụng và trả về SuperApp.
```js
import { closeApp } from 'x-app-sdk';

// Đóng ứng dụng
closeApp();

// Đóng ứng dụng với dữ liệu trả về
closeApp({ result: 'success', data: 'some data' });
```

### 9. Store - Lưu trữ cục bộ
#### `saveStore(data)`
Lưu dữ liệu vào bộ nhớ cục bộ của SuperApp.
```js
import { saveStore } from 'x-app-sdk';

const data = JSON.stringify({ key: 'value' });
saveStore(data).then(() => {
    console.log('Dữ liệu đã được lưu');
}).catch(error => {
    console.error('Lỗi lưu dữ liệu:', error);
});
```

#### `getStore()`
Lấy dữ liệu từ bộ nhớ cục bộ.
```js
import { getStore } from 'x-app-sdk';

getStore().then(result => {
    const data = JSON.parse(result.data);
    console.log('Dữ liệu lấy được:', data);
}).catch(error => {
    console.error('Lỗi lấy dữ liệu:', error);
});
```

#### `clearStore()`
Xóa tất cả dữ liệu trong bộ nhớ cục bộ.
```js
import { clearStore } from 'x-app-sdk';

clearStore().then(() => {
    console.log('Dữ liệu đã được xóa');
}).catch(error => {
    console.error('Lỗi xóa dữ liệu:', error);
});
```

### 10. User - Thông tin người dùng
#### `getInfo(key)`
Lấy thông tin người dùng từ SuperApp.
```js
import { getInfo, EKeyInfor } from 'x-app-sdk';

getInfo(EKeyInfor.USER_ID).then(info => {
    console.log('ID người dùng:', info.data);
}).catch(error => {
    console.error('Lỗi lấy thông tin:', error);
});
```

#### `getToken()`
Lấy token đăng nhập ngừoi dùng.
```js
import { getToken } from 'x-app-sdk';

getToken().then(token => {
    console.log('Token người dùng:', token);
}).catch(error => {
    console.error('Lỗi lấy thông tin:', error);
});
```

## Lưu ý quan trọng

- Tất cả các API đều yêu cầu SDK được khởi tạo trước khi sử dụng
- Một số tính năng yêu cầu quyền truy cập từ người dùng
- Khi chạy trong browser mode, một số tính năng sẽ trả về dữ liệu mẫu
- Luôn xử lý lỗi (catch) khi gọi các API bất đồng bộ
- Nhớ hủy đăng ký các listener khi không cần thiết để tránh memory leak

## Import tổng hợp

Bạn có thể import tất cả các services từ entry point chính:
```js
import {
    // Config
    configUIApp,
    
    // Device
    call, sms, vibrate,
    
    // Location
    currentLocation, requestLocationPermission,
    
    // Media
    openPickerImage, openPickerFile,
    
    // Notification
    listenNotifiactionEvent,
    
    // Payment
    paymentRequest, listenPaymentEvent,
    
    // Permission
    premissionsRequest,
    
    // Routing
    closeApp,
    
    // Store
    saveStore, getStore, clearStore,
    
    // User
    getInfo, getToken
} from 'x-app-sdk';
```

## Kết luận
Thư viện `x-app-sdk` giúp bạn dễ dàng tương tác với `superapp` cho ứng dụng của bạn.
