# X-App-SDK Integration Guide

## Tổng quan

Tài liệu này mô tả cách tích hợp mini app với `x-app-sdk` để lấy token và đóng app từ Super App. Implementation này đơn giản và chỉ sử dụng 2 API chính: `getToken()` và `closeApp()`.

## Cài đặt

### 1. Install x-app-sdk

```bash
npm install x-app-sdk@^1.1.2
```

### 2. Build Flutter web app

```bash
flutter build web
```

## Cách sử dụng

### Trong Super App

Super App không cần làm gì đặc biệt. x-app-sdk sẽ tự động detect Super App environment và sử dụng các method có sẵn.

**Lưu ý**: Mini app sử dụng x-app-sdk thật từ npm package, không phải mock.

### Trong Mini App (Flutter)

Mini app sẽ tự động lấy token từ Super App khi khởi động:

```dart
// Token được lấy tự động trong splash screen
// Không cần gọi thủ công

// Đóng app và trả về Super App
webCloseApp({
  'message': 'Task completed',
  'timestamp': DateTime.now().millisecondsSinceEpoch,
});
```

## API Reference

### Web Helper Functions

- `webInitializeXAppSDK()`: Khởi tạo x-app-sdk service
- `webGetToken()`: Lấy token từ Super App
- `webCloseApp(data)`: Đóng app và trả về Super App với data
- `webIsSDKInitialized()`: Kiểm tra SDK đã khởi tạo chưa
- `webGetCachedToken()`: Lấy token đã cache
- `webGetLastError()`: Lấy error message cuối cùng
- `webClearTokenCache()`: Xóa token cache
- `webResetSDK()`: Reset SDK service

### XAppSDKService

```dart
final service = XAppSDKService();

// Khởi tạo
await service.initialize();

// Lấy token
String? token = await service.getToken();

// Đóng app
await service.closeApp({'message': 'Done'});

// Kiểm tra trạng thái
bool isReady = service.isInitialized;
String? cachedToken = service.cachedToken;
String? error = service.lastError;
```

## Luồng hoạt động

1. **Khởi tạo**: App khởi tạo x-app-sdk khi start
2. **Splash Screen**: Tự động gọi `getToken()` để lấy token
3. **Fallback**: Nếu SDK không có token, fallback về URL params
4. **Login**: Sử dụng token để đăng nhập
5. **Close App**: Khi cần đóng app, gọi `closeApp()`

## Test

### Local Development

```bash
# Test với mock SDK
./scripts/test_x_app_sdk.sh
```

### Production

Không cần thay đổi gì. x-app-sdk sẽ tự động detect Super App environment và hoạt động đúng.

**Lưu ý**: x-app-sdk được load từ npm package, tự động detect Super App environment.

## Troubleshooting

### SDK không khởi tạo được

- Kiểm tra console log: `❌ XAppSDKService: x-app-sdk not found in window`
- Đảm bảo Super App đã load x-app-sdk trước khi load mini app

### Token không lấy được

- Kiểm tra console log: `❌ SplashScreen - Failed to get token from SDK`
- Fallback sẽ tự động sử dụng URL params
- Kiểm tra Super App có expose `getToken()` method không

### CloseApp không hoạt động

- Kiểm tra console log: `❌ XAppSDKService: closeApp method not found`
- Fallback sẽ tự động sử dụng `window.history.back()` hoặc `window.close()`

## Files liên quan

- `lib/web/x_app_sdk_service.dart` - Service chính
- `lib/web/web_helper_web.dart` - Web implementation
- `lib/web/web_helper_stub.dart` - Stub cho non-web platforms
- `lib/web/web_helper.dart` - Export file
- `lib/screen/splash/splash_screen_viewmodel.dart` - Tích hợp trong splash
- `lib/base/app_navigator.dart` - Sử dụng closeApp
- `lib/core/app_initializer.dart` - Khởi tạo SDK
- `web/index.html` - Mock SDK cho development
- `scripts/test_x_app_sdk.sh` - Script test
