import 'package:flutter/material.dart';

class NetworkImageWithAspectRatio extends StatefulWidget {
  final String imageUrl;
  final Widget? placeholder;
  final Widget? errorWidget;

  const NetworkImageWithAspectRatio({
    super.key,
    required this.imageUrl,
    this.placeholder,
    this.errorWidget,
  });

  @override
  State<NetworkImageWithAspectRatio> createState() => _NetworkImageWithAspectRatioState();
}

class _NetworkImageWithAspectRatioState extends State<NetworkImageWithAspectRatio> {
  double? _aspectRatio;
  bool _hasError = false;

  @override
  void initState() {
    super.initState();
    _loadImageInfo();
  }

  void _loadImageInfo() {
    final image = NetworkImage(widget.imageUrl);
    image.resolve(const ImageConfiguration()).addListener(
      ImageStreamListener(
            (ImageInfo info, bool synchronousCall) {
          final width = info.image.width;
          final height = info.image.height;
          setState(() {
            _aspectRatio = width / height;
            _hasError = false;
          });
        },
        onError: (dynamic error, stackTrace) {
          setState(() {
            _hasError = true;
          });
        },
      ),
    );
  }

  @override
  Widget build(BuildContext context) {
    // Nếu load lỗi => hiển thị errorWidget nếu có
    if (_hasError) {
      return widget.errorWidget ??
          Container(
            color: Colors.grey.shade200,
            alignment: Alignment.center,
            child: const Text("Load ảnh lỗi"),
          );
    }

    // Nếu chưa có _aspectRatio => hiển thị placeholder (progress, v.v.)
    if (_aspectRatio == null) {
      return widget.placeholder ??
          Container(
            color: Colors.grey.shade200,
            height: 200,
            alignment: Alignment.center,
            child: const CircularProgressIndicator(),
          );
    }

    // Có aspectRatio => hiển thị ảnh với AspectRatio
    return AspectRatio(
      aspectRatio: _aspectRatio!,
      child: Image.network(
        widget.imageUrl,
        fit: BoxFit.cover,
        // Nếu ảnh load xong aspect ratio nhưng khi vẽ vẫn lỗi => fallback
        errorBuilder: (context, error, stackTrace) {
          return widget.errorWidget ??
              Container(
                color: Colors.grey.shade200,
                alignment: Alignment.center,
                child: const Text("Load ảnh lỗi"),
              );
        },
      ),
    );
  }
}
