import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mypoint_flutter_app/features/affiliate/sub_widget/build_affiliate_brand.dart';
import 'package:mypoint_flutter_app/features/affiliate/sub_widget/build_affiliate_category.dart';
import 'package:mypoint_flutter_app/features/affiliate/sub_widget/build_affiliate_product_topsale.dart';
import 'package:mypoint_flutter_app/shared/widgets/back_button.dart';
import '../../shared/widgets/base_view/base_screen.dart';
import '../../shared/widgets/base_view/basic_state.dart';
import '../../app/routing/directional_action_type.dart';
import '../../core/theme/base_color.dart';
import '../../shared/router_gage.dart';
import '../../shared/widgets/bottom_sheet_helper.dart';
import '../../shared/widgets/custom_navigation_bar.dart';
import '../home/custom_widget/banner_carousel_widget.dart';
import '../popup_manager/popup_runner_helper.dart';
import 'affiliate_overview.dart';
import 'affiliate_popup_brands.dart';
import 'affiliate_tab_viewmodel.dart';
import 'model/affiliate_category_type.dart';

class AffiliateTabScreen extends BaseScreen {
  const AffiliateTabScreen({super.key});

  @override
  State<AffiliateTabScreen> createState() => _AffiliateTabScreenState();
}

class _AffiliateTabScreenState extends BaseState<AffiliateTabScreen> with BasicState, PopupOnInit {
  final AffiliateTabViewModel viewModel = Get.put(AffiliateTabViewModel());
  late var _canBackButton = false;

  @override
  void initState() {
    super.initState();
    final args = Get.arguments;
    if (args is Map) {
      _canBackButton = args['can_back_button'] as bool? ?? false;
    }
    viewModel.onShowAffiliateBrandPopup = (data) {
      if (!mounted) return;
      showAffiliateBrandPopup(context, data.$1, title: data.$2);
    };
    runPopupCheck(DirectionalScreenName.pointBack);
    viewModel.refreshData();
  }

  @override
  Widget createBody() {
    return Scaffold(
      backgroundColor: Colors.grey.shade50,
      appBar: CustomNavigationBar(
        title: "Mua sắm",
        leftButtons: _canBackButton ? [CustomBackButton()] : [],
        rightButtons: [
          IconButton(
            icon: const Icon(Icons.info, color: Colors.white),
            onPressed: () {
              final descriptions = viewModel.overview.value?.descriptions ?? [];
              if (descriptions.isNotEmpty) {
                BottomSheetHelper.showBottomSheetPopup(
                  child: AffiliateOverviewPopup(descriptions: viewModel.overview.value?.descriptions ?? []),
                );
              }
            },
          ),
        ],
      ),
      body: Obx(() {
        return RefreshIndicator(
          onRefresh: () async {
            await viewModel.refreshData(isShowLoading: false);
          },
          child: SingleChildScrollView(
            padding: const EdgeInsets.fromLTRB(16, 12, 16, 140),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              mainAxisAlignment: MainAxisAlignment.start,
              children: [
                GestureDetector(
                  onTap: () {
                    Get.toNamed(historyPointCashBackScreen);
                  },
                  child: Container(
                    padding: const EdgeInsets.all(12),
                    decoration: BoxDecoration(color: Colors.amber.shade100, borderRadius: BorderRadius.circular(12)),
                    child: Row(
                      children: [
                        const Text("Điểm hoàn:", style: TextStyle(fontSize: 18, fontWeight: FontWeight.normal)),
                        const SizedBox(width: 8),
                        Image.asset('assets/images/ic_point.png', width: 20, height: 20),
                        const SizedBox(width: 4),
                        const Text(
                          "0",
                          style: TextStyle(fontSize: 20, color: BaseColor.primary400, fontWeight: FontWeight.bold),
                        ),
                        const Spacer(),
                        Icon(Icons.arrow_forward_ios, color: BaseColor.primary400, size: 16),
                      ],
                    ),
                  ),
                ),
                const SizedBox(height: 16),
                SizedBox(
                  height: 130,
                  child: ListView(
                    scrollDirection: Axis.horizontal,
                    children: [
                      _buildStepCard("assets/images/banner_tutorial_refund_point_step1.png"),
                      const SizedBox(width: 12),
                      _buildStepCard("assets/images/banner_tutorial_refund_point_step2.png"),
                      const SizedBox(width: 12),
                      _buildStepCard("assets/images/banner_tutorial_refund_point_step3.png"),
                      const SizedBox(width: 12),
                      _buildStepCard("assets/images/banner_tutorial_refund_point_step4.png"),
                    ],
                  ),
                ),
                AffiliateBrand(brands: viewModel.affiliateBrands.value),
                if (viewModel.banners.isNotEmpty)...[
                  const SizedBox(height: 16),
                  BannerCarousel(
                    banners: viewModel.banners,
                    sectionConfig: null,
                    onTap: (item) => item.directionalScreen?.begin(),
                  ),
                ],
                AffiliateCategory(
                  categories: viewModel.affiliateCategories.value,
                  onTap: (category) {
                    if (category.code == AffiliateCategoryType.other) {
                      Get.toNamed(
                        affiliateCategoryGridScreen,
                        arguments: {"categories": viewModel.allAffiliateCategories},
                      );
                      return;
                    }
                    viewModel.affiliateBrandGetListBuyCategory(category);
                  },
                ),
                AffiliateProductTopSale(products: viewModel.affiliateProducts.value),
              ],
            ),
          ),
        );
      }),
    );
  }

  Widget _buildStepCard(String imagePath) {
    return ClipRRect(
      borderRadius: BorderRadius.circular(16),
      child: Image.asset(imagePath, fit: BoxFit.cover, width: 250),
    );
  }
}
