import 'package:flutter/material.dart';
import 'package:marquee/marquee.dart';

class CampaignMarqueeNoticeBar extends StatelessWidget {
  final String text;
  final String iconAsset; // ví dụ: assets/icons/ic_speaker.png

  const CampaignMarqueeNoticeBar({
    super.key,
    required this.text,
    this.iconAsset = 'assets/images/ic_speaker_toast.png',
  });

  @override
  Widget build(BuildContext context) {
    return Stack(
      clipBehavior: Clip.none,
      children: [
        Container(
          height: 28,
          margin: const EdgeInsets.only(left: 8, right: 8, top: 6),
          padding: const EdgeInsets.only(left: 36, right: 12),
          decoration: BoxDecoration(
            color: Colors.black.withOpacity(0.5),
            borderRadius: BorderRadius.circular(20),
          ),
          child: Center(
            child: Marquee(
              text: text,
              style: const TextStyle(color: Colors.white, fontSize: 14),
              scrollAxis: Axis.horizontal,
              crossAxisAlignment: CrossAxisAlignment.center,
              blankSpace: 60.0,
              velocity: 40.0,
              pauseAfterRound: Duration.zero,
              startPadding: 0.0,
              accelerationDuration: Duration(seconds: 1),
              accelerationCurve: Curves.linear,
              decelerationDuration: Duration(seconds: 1),
              decelerationCurve: Curves.linear,
            ),
          ),
        ),

        // Icon loa nằm ngoài trái
        Positioned(
          left: 8,
          top: 0,
          child: Image.asset(
            iconAsset,
            width: 40,
            height: 40,
          ),
        ),
      ],
    );
  }
}
