import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mypoint_flutter_app/shared/widgets/custom_toast_message.dart';
import '../../shared/widgets/base_view/base_screen.dart';
import '../../shared/widgets/base_view/basic_state.dart';
import '../../app/config/constants.dart';
import '../../core/theme/base_color.dart';
import '../../shared/router_gage.dart';
import '../../shared/widgets/custom_navigation_bar.dart';
import 'faqs_viewmodel.dart';

class FAQScreen extends BaseScreen {
  const FAQScreen({super.key});

  @override
  State<FAQScreen> createState() => _FAQScreenState();
}

class _FAQScreenState extends BaseState<FAQScreen> with BasicState {
  final FAQViewModel _controller = Get.put(FAQViewModel());

  @override
  Widget createBody() {
    return Scaffold(
      appBar: CustomNavigationBar(title: "Câu hỏi thường gặp"),
      body: Column(
        children: [
          Obx(() {
            if (_controller.faqItems.isEmpty) {
              return const Expanded(child: Center(child: Text("Không có dữ liệu.")));
            }
            return Expanded(child: _buildFAQList());
          }),
        ],
      ),
    );
  }

  Widget _buildFAQList() {
    return ListView.builder(
      itemCount: _controller.faqItems.length,
      itemBuilder: (context, index) {
        final item = _controller.faqItems[index];
        return GestureDetector(
          onTap: () {
            if (item.pageId != null && item.pageId!.isNotEmpty) {
              Get.toNamed(campaignDetailScreen, arguments: {"id": item.pageId});
            } else {
              showToastMessage(ErrorCodes.serverErrorMessage);
            }
          },
          child: Column(
            children: [
              Container(
                color: BaseColor.second200,
                child: ListTile(
                  leading: const Icon(Icons.help_outline, color: BaseColor.second800),
                  title: Text(
                    item.title ?? "",
                    style: const TextStyle(fontWeight: FontWeight.bold, color: BaseColor.second800),
                  ),
                  trailing: Icon(Icons.arrow_forward_ios, size: 16, color: BaseColor.second800),
                ),
              ),
              const SizedBox(height: 8),
              Padding(
                padding: const EdgeInsets.only(left: 56, right: 16, bottom: 10), // 👈 56 = icon width + padding mặc định
                child: Align(
                  alignment: Alignment.centerLeft,
                  child: Text(item.chapeau ?? "", style: const TextStyle(fontSize: 15, color: BaseColor.second600)),
                ),
              ),
              const SizedBox(height: 4),
            ],
          ),
        );
      },
    );
  }
}
