import 'package:json_annotation/json_annotation.dart';
import '../../../shared/widgets/alert/popup_data_model.dart';
import 'game_card_item_model.dart';

part 'game_bundle_item_model.g.dart';
@JsonSerializable()
class GameBundleItemModel {
  final String? id;
  final String? name;
  final String? icon;
  final String? background;
  final String? description;
  final List<GameCardItemModel>? options;
  final PopupDataModel? popup;

  GameBundleItemModel({
    this.id,
    this.name,
    this.icon,
    this.background,
    this.description,
    this.options,
    this.popup
  });

  factory GameBundleItemModel.fromJson(Map<String, dynamic> json) => _$GameBundleItemModelFromJson(json);
  Map<String, dynamic> toJson() => _$GameBundleItemModelToJson(this);
}