import '../../../app/config/callbacks.dart';

class TransactionHistoryModel {
  final String? poolCode;
  final String? transactionTag;
  final String? transactionTagDescription;
  final String? brandName;
  final String? invoiceNumber;
  final String? currencyCode;
  final String? redeemTotal;
  final String? transactionType;
  final String? brandId;
  final String? brandCode;
  final String? poolId;
  final String? transactionDatetime;
  final String? transactionSequenceId;
  final String? brandLogo;
  final String? rewardTotal;
  final String? adjustTotal;

  const TransactionHistoryModel({
    this.poolCode,
    this.transactionTag,
    this.transactionTagDescription,
    this.brandName,
    this.invoiceNumber,
    this.currencyCode,
    this.redeemTotal,
    this.transactionType,
    this.brandId,
    this.brandCode,
    this.poolId,
    this.transactionDatetime,
    this.transactionSequenceId,
    this.brandLogo,
    this.rewardTotal,
    this.adjustTotal,
  });

  factory TransactionHistoryModel.fromJson(Json json) {
    return TransactionHistoryModel(
      poolCode: json['pool_code'] as String?,
      transactionTag: json['transaction_tag'] as String?,
      transactionTagDescription: json['transaction_tag_description'] as String?,
      brandName: json['brand_name'] as String?,
      invoiceNumber: json['invoice_number'] as String?,
      currencyCode: json['currency_code'] as String?,
      redeemTotal: json['redeem_total'] as String?,
      transactionType: json['transaction_type'] as String?,
      brandId: json['brand_id'] as String?,
      brandCode: json['brand_code'] as String?,
      poolId: json['pool_id'] as String?,
      transactionDatetime: json['transaction_datetime'] as String?,
      transactionSequenceId: json['transaction_sequence_id'] as String?,
      brandLogo: json['brand_logo'] as String?,
      rewardTotal: json['reward_total'] as String?,
      adjustTotal: json['adjust_total'] as String?,
    );
  }

  Json toJson() => {
    'pool_code': poolCode,
    'transaction_tag': transactionTag,
    'transaction_tag_description': transactionTagDescription,
    'brand_name': brandName,
    'invoice_number': invoiceNumber,
    'currency_code': currencyCode,
    'redeem_total': redeemTotal,
    'transaction_type': transactionType,
    'brand_id': brandId,
    'brand_code': brandCode,
    'pool_id': poolId,
    'transaction_datetime': transactionDatetime,
    'transaction_sequence_id': transactionSequenceId,
    'brand_logo': brandLogo,
    'reward_total': rewardTotal,
    'adjust_total': adjustTotal,
  };
}
