import 'package:json_annotation/json_annotation.dart';

part 'image_model.g.dart';
@JsonSerializable()
class ImageModel {
  final String? id;
  final String? type;
  final String? caption;
  @JsonKey(name: 'image_type')
  final String? imageType;
  @JsonKey(name: 'image_url')
  final String? imageUrl;

  const ImageModel({
    this.id,
    this.type,
    this.caption,
    this.imageType,
    this.imageUrl,
  });

  factory ImageModel.fromJson(Map<String, dynamic> json) => _$ImageModelFromJson(json);
  Map<String, dynamic> toJson() => _$ImageModelToJson(this);
}
