import 'package:json_annotation/json_annotation.dart';

part 'interested_categories_model.g.dart';
@JsonSerializable()
class InterestedCategoriesResponse {
  @JsonKey(name: 'list_items')
  final List<InterestedCategoryItem>? listItems;

  InterestedCategoriesResponse({this.listItems});

  factory InterestedCategoriesResponse.fromJson(Map<String, dynamic> json) =>
      _$InterestedCategoriesResponseFromJson(json);
  Map<String, dynamic> toJson() => _$InterestedCategoriesResponseToJson(this);
}

@JsonSerializable()
class InterestedCategoryItem {
  final String? id;
  final String? subscribed;
  @JsonKey(name: 'category_code')
  final String? categoryCode;
  @JsonKey(name: 'category_name')
  final String? categoryName;
  @JsonKey(name: 'image_url')
  final String? imageUrl;

  InterestedCategoryItem({
    this.id,
    this.subscribed,
    this.categoryCode,
    this.categoryName,
    this.imageUrl,
  });

  factory InterestedCategoryItem.fromJson(Map<String, dynamic> json) =>
      _$InterestedCategoryItemFromJson(json);

  Map<String, dynamic> toJson() => _$InterestedCategoryItemToJson(this);
}
