import 'package:mypoint_flutter_app/shared/navigation/directional_screen.dart';

class RewardInviteItemModel {
  String? type;
  String? icon;
  int? quantity;

  RewardInviteItemModel({this.type, this.icon, this.quantity});

  factory RewardInviteItemModel.fromJson(Map<String, dynamic> json) {
    return RewardInviteItemModel(
      type: json['type'],
      icon: json['icon'],
      quantity: json['quantity'],
    );
  }
}

class InviteRewardFriendModel {
  String? title;
  List<RewardInviteItemModel>? rewards;

  InviteRewardFriendModel({this.title, this.rewards});

  factory InviteRewardFriendModel.fromJson(Map<String, dynamic> json) {
    return InviteRewardFriendModel(
      title: json['title'],
      rewards: (json['rewards'] as List<dynamic>?)
          ?.map((e) => RewardInviteItemModel.fromJson(e))
          .toList(),
    );
  }
}

class InviteFriendDetailModel {
  String? id;
  String? name;
  String? bannerUrl;
  String? backgroundColor;
  String? inviteLink;
  String? inviteCodeDefault;
  String? shareContent;
  InviteRewardFriendModel? reward;

  InviteFriendDetailModel({
    this.id,
    this.name,
    this.bannerUrl,
    this.backgroundColor,
    this.inviteLink,
    this.inviteCodeDefault,
    this.shareContent,
    this.reward,
  });

  factory InviteFriendDetailModel.fromJson(Map<String, dynamic> json) {
    return InviteFriendDetailModel(
      id: json['id'],
      name: json['name'],
      bannerUrl: json['banner_url'],
      backgroundColor: json['background_color'],
      inviteLink: json['invite_link'],
      inviteCodeDefault: json['invite_code_default'],
      shareContent: json['share_content'],
      reward: json['reward'] != null
          ? InviteRewardFriendModel.fromJson(json['reward'])
          : null,
    );
  }
}

class CampaignStepsInviteFriendDetailModel {
  String? description;
  List<CampaignStepItemInviteFriendDetailModel>? steps;

  CampaignStepsInviteFriendDetailModel({
    this.description,
    this.steps,
  });

  factory CampaignStepsInviteFriendDetailModel.fromJson(Map<String, dynamic> json) {
    return CampaignStepsInviteFriendDetailModel(
      description: json['description'],
      steps: (json['steps'] as List<dynamic>?)
          ?.map((e) => CampaignStepItemInviteFriendDetailModel.fromJson(e))
          .toList(),
    );
  }
}

class CampaignStepItemInviteFriendDetailModel {
  String? description;
  String? title;

  CampaignStepItemInviteFriendDetailModel({
    this.description,
    this.title,
  });

  factory CampaignStepItemInviteFriendDetailModel.fromJson(Map<String, dynamic> json) {
    return CampaignStepItemInviteFriendDetailModel(
      description: json['description'],
      title: json['title'],
    );
  }
}

class CampaignInviteFriendItemModel {
  String? id;
  String? name;
  String? description;
  String? avatarUrl;
  String? bannerUrl;
  String? inviteDescription;
  RewardInviteItemModel? reward;
  String? rules;
  String? inviteLink;
  String? rewardContent;
  CampaignStepsInviteFriendDetailModel? steps;
  int? rulesId;

  CampaignInviteFriendItemModel({
    this.id,
    this.name,
    this.description,
    this.avatarUrl,
    this.bannerUrl,
    this.inviteDescription,
    this.reward,
    this.rules,
    this.inviteLink,
    this.rewardContent,
    this.steps,
    this.rulesId,
  });

  factory CampaignInviteFriendItemModel.fromJson(Map<String, dynamic> json) {
    return CampaignInviteFriendItemModel(
      id: json['id'],
      name: json['name'],
      description: json['description'],
      avatarUrl: json['avatar_url'],
      bannerUrl: json['banner_url'],
      inviteDescription: json['invite_description'],
      reward: json['reward'] != null
          ? RewardInviteItemModel.fromJson(json['reward'])
          : null,
      rules: json['rules'],
      inviteLink: json['invite_link'],
      rewardContent: json['reward_content'],
      steps: json['steps'] != null
          ? CampaignStepsInviteFriendDetailModel.fromJson(json['steps'])
          : null,
      rulesId: json['rules_id'],
    );
  }
}

class CampaignInviteFriendDetail {
  String? title;
  List<CampaignInviteFriendItemModel>? campaigns;

  CampaignInviteFriendDetail({
    this.title,
    this.campaigns,
  });

  factory CampaignInviteFriendDetail.fromJson(Map<String, dynamic> json) {
    return CampaignInviteFriendDetail(
      title: json['title'] as String?,
      campaigns: (json['campaigns'] as List<dynamic>?)
          ?.map((e) => CampaignInviteFriendItemModel.fromJson(e))
          .toList(),
    );
  }
}

class InviteFriendResponse {
  final String? sms;

  InviteFriendResponse({this.sms});

  factory InviteFriendResponse.fromJson(Map<String, dynamic> json) {
    return InviteFriendResponse(
      sms: json['sms'] as String?,
    );
  }

  Map<String, dynamic> toJson() {
    return {
      'sms': sms,
    };
  }
}

class InviteFriendAcceptResponse {
  final String? content;
  final String? title;
  final String? clickActionType;
  final String? clickActionParam;

  DirectionalScreen? get directionalScreen {
    return DirectionalScreen.build(
      clickActionType: clickActionType,
      clickActionParam: clickActionParam,
    );
  }

  InviteFriendAcceptResponse({
    this.content,
    this.title,
    this.clickActionType,
    this.clickActionParam,
  });

  factory InviteFriendAcceptResponse.fromJson(Map<String, dynamic> json) {
    return InviteFriendAcceptResponse(
      content: json['content'] as String?,
      title: json['title'] as String?,
      clickActionType: json['click_action_type'] as String?,
      clickActionParam: json['click_action_param'] as String?,
    );
  }

  Map<String, dynamic> toJson() {
    return {
      'content': content,
      'title': title,
      'click_action_type': clickActionType,
      'click_action_param': clickActionParam,
    };
  }
}