import 'package:get/get_rx/src/rx_types/rx_types.dart';
import 'package:mypoint_flutter_app/core/network/restful_api_client_all_request.dart';
import '../../../app/config/callbacks.dart';
import '../../../core/network/restful_api_viewmodel.dart';
import '../models/invite_friend_campaign_model.dart';

class ReferralCodeInviteFriendViewModel extends RestfulApiViewModel {
  final Rxn<CampaignInviteFriendItemModel> campaignDetail = Rxn<CampaignInviteFriendItemModel>();
  final Rxn<CampaignInviteFriendDetail> referralCampaignData = Rxn<CampaignInviteFriendDetail>();
  void Function(String message)? onShowAlertError;
  void Function(InviteFriendAcceptResponse data)? acceptCampaignResponse;

  Future<void> getInviteFriendCampaignDetail(String id, Json body) async {
    await callApi<CampaignInviteFriendItemModel>(
      request: () => client.getInviteFriendCampaignDetail(id, body),
      onSuccess: (data, _) {
        campaignDetail.value = data;
      },
      onFailure: (msg, _, _) async {
        onShowAlertError?.call(msg);
      },
    );
  }

  Future<void> acceptCampaign(CampaignInviteFriendItemModel campaign, String code) async {
    await callApi<InviteFriendAcceptResponse>(
      request: () => client.referralCampaignAccept(campaign.id ?? '', {'username': code}),
      onSuccess: (data, _) {
        acceptCampaignResponse?.call(data);
      },
      onFailure: (msg, _, _) async {
        onShowAlertError?.call(msg);
      },
    );
  }

  Future<void> getCampaignReferralCodeInvite(String code) async {
    await callApi<CampaignInviteFriendDetail>(
      request: () => client.getDetailCampaignInviteFriend(),
      onSuccess: (data, _) {
        referralCampaignData.value = data;
      },
      onFailure: (msg, _, _) async {
        onShowAlertError?.call(msg);
      },
    );
  }
}
