import 'package:json_annotation/json_annotation.dart';

part 'login_token_response_model.g.dart';
@JsonSerializable()
class LoginTokenResponseModel {
  String? accessToken;
  String? refreshToken;
  bool? forceResetPassword;

  LoginTokenResponseModel({this.accessToken, this.refreshToken, this.forceResetPassword});

  LoginTokenResponseModel.fromRefreshToken(TokenRefreshResponseModel refresh)
      : accessToken = refresh.accessToken,
        refreshToken = refresh.refreshToken,
        forceResetPassword = false;

  factory LoginTokenResponseModel.fromJson(Map<String, dynamic> json) => _$LoginTokenResponseModelFromJson(json);
  Map<String, dynamic> toJson() => _$LoginTokenResponseModelToJson(this);
}

class TokenRefreshResponseModel {
  String? accessToken;
  String? refreshToken;

  TokenRefreshResponseModel({this.accessToken, this.refreshToken});
  factory TokenRefreshResponseModel.fromJson(Map<String, dynamic> json) => TokenRefreshResponseModel(
    accessToken: json['access_token'] as String?,
    refreshToken: json['refresh_token'] as String?,
  );

  Map<String, dynamic> toJson() => {
    'access_token': accessToken,
    'refresh_token': refreshToken,
  };
}