import 'package:json_annotation/json_annotation.dart';
import 'notification_item_model.dart';

part 'notification_list_data_model.g.dart';
@JsonSerializable()
class NotificationListDataModel {
  final String? start;
  final String? limit;
  final String? total;
  final String? unread;
  @JsonKey(name: 'list_items')
  final List<NotificationItemModel>? items;

  NotificationListDataModel({
    this.start,
    this.limit,
    this.total,
    this.unread,
    this.items,
  });

  factory NotificationListDataModel.fromJson(Map<String, dynamic> json) =>
      _$NotificationListDataModelFromJson(json);
  Map<String, dynamic> toJson() => _$NotificationListDataModelToJson(this);
}