import 'package:get/get.dart';
import 'package:mypoint_flutter_app/core/network/restful_api_client_all_request.dart';
import 'package:mypoint_flutter_app/shared/router_gage.dart';
import '../../shared/widgets/base_view/base_response_model.dart';
import '../../core/network/restful_api_viewmodel.dart';
import '../../app/config/constants.dart';
import '../../shared/preferences/data_preference.dart';
import '../../shared/widgets/custom_toast_message.dart';
import 'model/otp_verify_response_model.dart';
import 'otp_viewmodel.dart';

class DeleteAccountOtpRepository extends RestfulApiViewModel implements IOtpRepository {
  DeleteAccountOtpRepository(this.phoneNumber, this.otpTtl);

  @override
  int otpTtl;
  @override
  String phoneNumber;

  @override
  Future<void> sendOtp() async {}

  @override
  Future<BaseResponseModel<OTPVerifyResponseModel>> verifyOtp(String otpCode) {
    showLoading();
    return client.verifyDeleteAccount(otpCode).then((value) async {
      hideLoading();
      if (value.isSuccess) {
        await DataPreference.instance.clearBioToken(phoneNumber);
        await DataPreference.instance.clearData();
        Get.offAllNamed(onboardingScreen);
        showToastMessage("Xóa tài khoản thành công");
      }
      return value;
    });
  }

  @override
  Future<int?> resendOtp() async {
    showLoading();
    try {
      final value = await client.requestOtpDeleteAccount();
      if (value.isSuccess) {
        otpTtl = value.data?.resendAfterSecond ?? Constants.otpTtl;
        return otpTtl;
      }
      final mgs = value.errorMessage ?? Constants.commonError;
      showToastMessage(mgs);
      return null;
    } finally {
      hideLoading();
    }
  }
}
