enum PersonalGender {
  female,
  male,
  unknown;

  static PersonalGender from(String gender) {
    switch (gender) {
      case 'F':
        return PersonalGender.female;
      case 'M':
        return PersonalGender.male;
      default:
        return PersonalGender.unknown;
    }
  }

  static PersonalGender fromInt(String gender) {
    switch (gender) {
      case '1':
        return PersonalGender.female;
      case '0':
        return PersonalGender.male;
      default:
        return PersonalGender.unknown;
    }
  }

  String get value {
    switch (this) {
      case PersonalGender.female:
        return 'F';
      case PersonalGender.male:
        return 'M';
      case PersonalGender.unknown:
        return 'U';
    }
  }

  String get display {
    switch (this) {
      case PersonalGender.female:
        return 'Nữ';
      case PersonalGender.male:
        return 'Nam';
      case PersonalGender.unknown:
        return 'Khác';
    }
  }
}
