import 'package:flutter/material.dart';
import 'package:mypoint_flutter_app/features/popup_manager/popup_manager_screen.dart';
import '../../app/routing/directional_action_type.dart';
import 'popup_manager_viewmodel.dart';

class PopupRunner {
  static Future<void> _showIfAvailable(BuildContext context, {required String screenName}) async {
    await PopupManagerViewModel.instance.ensureLoaded();
    final popup = PopupManagerViewModel.instance.getForScreen(screenName,);
    if (popup == null || (popup.id ?? '').isEmpty) return;
    if (!context.mounted) return;
    await showPopupManagerScreen(
      context,
      modelPopup: popup,
    );
  }
}

mixin PopupOnInit<T extends StatefulWidget> on State<T> {
  bool _popupChecked = false;

  void runPopupCheck(DirectionalScreenName directional) {
    if (_popupChecked) return;
    _popupChecked = true;
    WidgetsBinding.instance.addPostFrameCallback((_) async {
      if (!mounted) return;
      await PopupRunner._showIfAvailable(
        context,
        screenName: directional.rawValue,
      );
    });
  }
}