import 'package:get/get_rx/src/rx_types/rx_types.dart';
import 'package:mypoint_flutter_app/core/network/restful_api_client_all_request.dart';
import 'package:mypoint_flutter_app/features/transaction/history/transaction_history_model.dart';
import '../../../core/network/restful_api_viewmodel.dart';

class TransactionHistoryDetailViewModel extends RestfulApiViewModel {
  String orderID;
  TransactionHistoryDetailViewModel({required this.orderID});

  var transactionData = Rxn<TransactionHistoryModel>();
  void Function(String message)? onShowAlertError;

  @override
  void onInit() {
    super.onInit();
    _loadData();
  }

  Future<void> _loadData() async {
    await callApi<TransactionHistoryModel>(
      request: () => client.getTransactionHistoryDetail(orderID),
      onSuccess: (data, _) {
        transactionData.value = data;
      },
      onFailure: (message, _, _) {
        onShowAlertError?.call(message);
      },
    );
  }
}
