import 'package:json_annotation/json_annotation.dart';

part 'payment_bank_account_info_model.g.dart';
@JsonSerializable()
class PaymentBankAccountInfoModel {
  final int? id;
  @JsonKey(name: 'payment_method')
  final String? paymentMethod;
  @JsonKey(name: 'card_name')
  final String? cardName;
  @JsonKey(name: 'card_number')
  final String? cardNumber;
  @JsonKey(name: 'card_date')
  final String? cardDate;
  @JsonKey(name: 'bank_logo')
  final String? bankLogo;
  @JsonKey(name: 'bank_name')
  final String? bankName;
  @JsonKey(name: 'bank_short_name')
  final String? bankShortName;
  @JsonKey(name: 'bank_code')
  final String? bankCode;
  @JsonKey(name: 'is_default')
  final bool? isDefault;
  bool? isSelected;
  @JsonKey(name: 'form_bank_title')
  final String? formBankTitle;
  @JsonKey(name: 'form_bank_number_title')
  final String? formBankNumberTitle;
  @JsonKey(name: 'form_message_delete')
  final String? formMessageDelete;
  @JsonKey(name: 'form_bank_background')
  final String? formBankBackground;
  @JsonKey(name: 'form_bank_name')
  final String? formBankName;
  @JsonKey(name: 'form_bank_number')
  final String? formBankNumber;

  PaymentBankAccountInfoModel({
    this.id,
    this.paymentMethod,
    this.cardName,
    this.cardNumber,
    this.cardDate,
    this.bankLogo,
    this.bankName,
    this.bankShortName,
    this.bankCode,
    this.isDefault,
    required this.isSelected, // initialize in constructor
    this.formBankTitle,
    this.formBankNumberTitle,
    this.formMessageDelete,
    this.formBankBackground,
    this.formBankName,
    this.formBankNumber,
  });

  factory PaymentBankAccountInfoModel.fromJson(Map<String, dynamic> json) =>
      _$PaymentBankAccountInfoModelFromJson(json);
  Map<String, dynamic> toJson() => _$PaymentBankAccountInfoModelToJson(this);
}
