enum PaymentMethodType {
  card,
  wallet,
  transfer,
  internalCard;

  factory PaymentMethodType.fromString(String value) {
    switch (value) {
      case 'CARD':
        return PaymentMethodType.card;
      case 'WALLET':
        return PaymentMethodType.wallet;
      case 'VA_QRCODE':
        return PaymentMethodType.transfer;
      case 'INTERNATIONAL_CARD':
        return PaymentMethodType.internalCard;
      default:
        throw ArgumentError('Unknown PaymentMethodType: $value');
    }
  }

  String get rawValue {
    switch (this) {
      case PaymentMethodType.card:
        return 'CARD';
      case PaymentMethodType.wallet:
        return 'WALLET';
      case PaymentMethodType.transfer:
        return 'VA_QRCODE';
      case PaymentMethodType.internalCard:
        return 'INTERNATIONAL_CARD';
    }
  }

  String get methodBillEVN {
    switch (this) {
      case PaymentMethodType.card:
        return 'DomesticATM';
      case PaymentMethodType.wallet:
        return 'VitapayWallet';
      case PaymentMethodType.transfer:
        return 'VA_QRCODE';
      case PaymentMethodType.internalCard:
        return 'INTERNATIONAL_CARD';
    }
  }
}
