import 'package:json_annotation/json_annotation.dart';

part 'product_store_model.g.dart';
@JsonSerializable()
class ProductStoreModel {
  final int? id;
  final String? code;
  final String? name;
  final String? phone;
  final String? email;
  final String? fax;
  final String? address;
  final double? longitude;
  final double? latitude;
  final double? distance;
  @JsonKey(name: 'district_id')
  final String? districtId;
  @JsonKey(name: 'district_name')
  final String? districtName;
  @JsonKey(name: 'city_id')
  final String? cityId;
  @JsonKey(name: 'city_name')
  final String? cityName;

  ProductStoreModel({
    this.id,
    this.code,
    this.name,
    this.phone,
    this.email,
    this.fax,
    this.address,
    this.longitude,
    this.latitude,
    this.distance,
    this.districtId,
    this.districtName,
    this.cityId,
    this.cityName,
  });

  factory ProductStoreModel.fromJson(Map<String, dynamic> json) => _$ProductStoreModelFromJson(json);
  Map<String, dynamic> toJson() => _$ProductStoreModelToJson(this);

  String get displayDistance {
    final doubleValue = distance ?? 0;
    if (doubleValue == 0) {
      return "";
    }
    return "${doubleValue.toStringAsFixed(1)} km";
  }
}