import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mypoint_flutter_app/shared/widgets/image_loader.dart';
import '../../shared/router_gage.dart';
import '../../shared/widgets/custom_navigation_bar.dart';
import '../faqs/faqs_model.dart';
import '../news/news_list_viewmodel.dart';

class VplayGameCenterScreen extends StatelessWidget {
  const VplayGameCenterScreen({super.key});

  @override
  Widget build(BuildContext context) {
    final viewModel = Get.put(NewsListViewModel(folderUri: "GAME-VPLAY"));
    final width = MediaQuery.of(context).size.width;
    final space = 12.0;
    final itemWidth = (width - space * 3) / 2;

    return Scaffold(
      appBar: CustomNavigationBar(title: "Trung tâm trò chơi"),
      body: Obx(() {
        final items = viewModel.newsList.value;
        return Padding(
          padding: const EdgeInsets.all(16.0),
          child: GridView.builder(
            itemCount: items.length,
            gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
              crossAxisCount: 2,
              crossAxisSpacing: space,
              mainAxisSpacing: space,
              childAspectRatio: itemWidth/(itemWidth + 60),
            ),
            itemBuilder: (context, index) {
              final item = items[index];
              return GestureDetector(
                onTap: () {
                  Get.toNamed(campaignDetailScreen, arguments: {"id": item.pageId ?? ""});
                },
                child: _buildVplayGameItem(item, itemWidth),
              );
            },
          ),
        );
      }),
    );
  }

  Widget _buildVplayGameItem(PageItemModel item, double itemWidth) {
    return Column(
      mainAxisSize: MainAxisSize.min,
      children: [
        ClipRRect(
          borderRadius: BorderRadius.circular(20),
          child: loadNetworkImage(
            url: item.thumbnail ?? '',
            width: itemWidth,
            height: itemWidth,
            fit: BoxFit.cover,
            placeholderAsset: "assets/images/bg_default_11.png",
          ),
        ),
        const SizedBox(height: 4),
        Text(
          item.title ?? '',
          textAlign: TextAlign.center,
          maxLines: 2,
          style: const TextStyle(fontSize: 15, fontWeight: FontWeight.bold),
        ),
      ],
    );
  }
}
