import 'package:get/get.dart';
import '../../../features/home/header_home_viewmodel.dart';

class UserPointManager {
  UserPointManager._();
  static final UserPointManager _instance = UserPointManager._();
  factory UserPointManager() => _instance;

  final HeaderHomeRepository _repository = HeaderHomeRepository();
  final RxInt _point = 0.obs;

  RxInt get pointStream => _point;
  int get point => _point.value;

  void setPoint(int value) {
    if (point == value) return;
    _point.value = value;
  }

  Future<int?> fetchUserPoint({bool withLoading = false}) async {
    await _repository.fetchHeader(withLoading: withLoading);
    return _point.value;
  }
}
