import 'button_config_model.dart';
import 'package:json_annotation/json_annotation.dart';
import 'data_alert_model.dart';

part 'popup_data_model.g.dart';
@JsonSerializable()
class PopupDataModel {
  @JsonKey(name: "header_img")
  final String? urlHeaderImg;
  final String? title;
  final String? description;
  final String? value;
  @JsonKey(name: "button_confirm")
  final ButtonConfigModel? buttonConfirm;
  @JsonKey(name: "button_cancel")
  final ButtonConfigModel? buttonCancel;
  @JsonKey(name: "local_img")
  final String? localHeaderImg;

  DataAlertModel get dataAlertModel {
    return DataAlertModel(
      urlHeaderImage: urlHeaderImg,
      localHeaderImage: localHeaderImg,
      title: title,
      description: description,
      buttons: [buttonConfirm?.alertButton, buttonCancel?.alertButton],
    );
  }

  PopupDataModel({
    this.urlHeaderImg,
    this.title,
    this.description,
    this.value,
    this.buttonConfirm,
    this.buttonCancel,
    this.localHeaderImg,
  });

  factory PopupDataModel.fromJson(Map<String, dynamic> json) => _$PopupDataModelFromJson(json);

  Map<String, dynamic> toJson() => _$PopupDataModelToJson(this);

  static PopupDataModel? error(String mgs) {
    return PopupDataModel(
      urlHeaderImg: null,
      title: null,
      description: mgs,
      value: null,
      buttonConfirm: null,
      buttonCancel: null,
      localHeaderImg: 'assets/images/ic_pipi_03.png',
    );
  }
}