export declare const call: (phoneNumber: string) => Promise<FlutterMessageResponse | void>;

export declare const clearStore: () => Promise<FlutterMessageResponse>;

export declare const closeApp: (data?: Record<string, string | object>) => void;

export declare const configUIApp: (config: Partial<IViewUiConfig>) => Promise<FlutterMessageResponse>;

declare class CoreSdk {
    private handlers;
    private isInitialized;
    private isBrowserMode;
    private cachedInfo;
    private infoRequests;
    private premissionEvent;
    constructor();
    private initialize;
    private setupMessageHandler;
    private handleInfoUpdate;
    private handleMessage;
    send(type: ETypeRequest, data?: Record<string, string | object | undefined>): void;
    on(type: ETypeResponse, handler: MessageHandler): void;
    off(type: string, handler: MessageHandler): void;
    getBrowserMode(): boolean;
    getInitialized(): boolean;
    getCachedInfo(key: string): unknown | undefined;
    getInfoRequests(): Map<string, ((value: Record<string, string | object>) => void)[]>;
    setInfoRequest(key: string, resolvers: ((value: Record<string, string | object>) => void)[]): void;
    checkPremissionEvent(type: ETypeRequest): boolean;
}

export declare const currentLocation: () => Promise<FlutterMessageResponse<ICurrentLocation>>;

export declare enum EHeaderMode {
    MINI = "mini",
    FULL = "full"
}

export declare enum EIconNavigationPosision {
    RIGHT = "right",
    LEFT = "left"
}

export declare enum EKeyInfor {
    USER = "user"
}

export declare enum EMediaType {
    gallery = "gallery",
    camera = "camera"
}

export declare enum EStatus {
    SUCCESS = "success",
    ERROR = "error",
    PREMISSION_ERROR = "premissionError"
}

export declare enum ETypeRequest {
    RequestConfigUIApp = "requestConfigUIApp",
    RequestInfo = "requestInfo",
    RequestToken = "requestToken",
    RequestCloseApp = "requestCloseApp",
    RequestPickerImage = "requestPickerImage",
    RequestPickerFile = "requestPickerFile",
    RequestVibrate = "requestVibrate",
    RequestCall = "requestCall",
    RequestSms = "requestSms",
    RequestLocationPermission = "requestLocationPermission",
    RequestCurrentLocation = "requestCurrentLocation",
    RequestPayment = "requestPayment",
    requestGetPermission = "requestGetPermission",
    requestSaveStore = "requestSaveStore",
    requestGetStore = "requestGetStore",
    requestClearStore = "requestClearStore"
}

export declare enum ETypeResponse {
    ResponseConfigApp = "responseConfigUIApp",
    ResponseInfo = "responseInfo",
    ResponseToken = "responseToken",
    ResponsePickerImage = "responsePickerImage",
    ResponsePickerFile = "responsePickerFile",
    ResponseVibrate = "responseVibrate",
    ResponseCall = "responseCall",
    ResponseSms = "responseSms",
    ResponseLocationPermission = "responseLocationPermission",
    ResponseCurrentLocation = "responseCurrentLocation",
    ResponseCloseApp = "responseCloseApp",
    ResponsePayment = "responsePayment",
    ResponseNotification = "responseNotification",
    ResponseGetPermisstion = "responseGetPermisstion",
    responseSaveStore = "responseSaveStore",
    responseGetStore = "responseGetStore",
    responseClearStore = "responseClearStore"
}

export declare const fltSDK: CoreSdk;

export declare interface FlutterMessage {
    type: string;
    data?: Record<string, string | object | undefined>;
}

export declare interface FlutterMessageResponse<T = unknown> {
    status: EStatus;
    type: ETypeResponse;
    data?: T | undefined;
}

export declare const getInfo: (key: EKeyInfor) => Promise<FlutterMessageResponse>;

export declare const getStore: () => Promise<FlutterMessageResponse<string>>;

export declare const getToken: () => Promise<FlutterMessageResponse<string>>;

export declare interface ICurrentLocation {
    latitude: number;
    longitude: number;
}

export declare interface IFileResult {
    path: string;
    base64: string;
    size: number;
}

export declare interface IInfor {
    user: Record<string, string | object | number>;
}

export declare interface ImageResult {
    path: string;
    base64: string;
}

export declare interface INotificationResult {
    status: string;
}

export declare interface IPaymentRequest {
    partnerOrderId: string;
    totalAmount: number;
    extra?: string;
}

export declare interface IPaymentResult {
    status: string;
    message: string;
}

export declare interface IViewUiConfig {
    headerColor?: string;
    headerTitle?: string;
    headerTextColor?: string;
    headerSubTitle?: string;
    headerIcon?: string;
    mode?: EHeaderMode;
    iconNavigationColor?: string;
    navigationColor?: string;
    iconNavigationPosision?: EIconNavigationPosision;
}

export declare const listenNotifiactionEvent: (callback: (data: FlutterMessageResponse) => void, customSdk?: typeof fltSDK) => (() => void);

export declare const listenPaymentEvent: (callback: (data: FlutterMessageResponse<IPaymentResult>) => void, customSdk?: typeof fltSDK) => (() => void);

export declare interface MessageHandler<T = unknown> {
    (data: FlutterMessageResponse<T>): void;
}

export declare const openPickerFile: () => Promise<FlutterMessageResponse<IFileResult>>;

export declare const openPickerImage: (type: EMediaType) => Promise<FlutterMessageResponse<ImageResult>>;

export declare const paymentRequest: (body: IPaymentRequest) => Promise<FlutterMessageResponse<IPaymentResult>>;

export declare const premissionsRequest: (type: ETypeRequest) => Promise<FlutterMessageResponse<boolean>>;

export declare const requestLocationPermission: () => Promise<FlutterMessageResponse>;

export declare const saveStore: (data: string) => Promise<FlutterMessageResponse>;

export declare const sms: (phoneNumber: string) => Promise<FlutterMessageResponse | void>;

export declare const vibrate: () => Promise<FlutterMessageResponse | void>;

export { }


declare global {
    interface Window {
        flutter_inappwebview?: {
            callHandler: (handlerName: string, ...args: any[]) => Promise<any>;
        };
        receiveFromFlutter?: (message: string) => void;
    }
}
