import '../../base/base_response_model.dart';
import '../../configs/api_paths.dart';
import '../../configs/callbacks.dart';
import '../../networking/restful_api_client.dart';
import '../../preference/data_preference.dart';
import '../../screen/location_address/models/district_address_model.dart';
import '../../screen/location_address/models/province_address_model.dart';

class LocationApi {
  LocationApi(this.client);

  final RestfulAPIClient client;

  Future<BaseResponseModel<ProvinceAddressResponse>> locationProvinceGetList() {
    final token = DataPreference.instance.token ?? '';
    final body = {'access_token': token, 'country_code2': 'VN'};
    return client.requestNormal(
      APIPaths.locationProvinceGetList,
      Method.POST,
      body,
      (data) => ProvinceAddressResponse.fromJson(data as Json),
    );
  }

  Future<BaseResponseModel<DistrictAddressResponse>> locationDistrictGetList(
    String provinceCode,
  ) {
    final token = DataPreference.instance.token ?? '';
    final body = {'access_token': token, 'province_code': provinceCode};
    return client.requestNormal(
      APIPaths.locationDistrictGetList,
      Method.POST,
      body,
      (data) => DistrictAddressResponse.fromJson(data as Json),
    );
  }
}
